/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import jakarta.xml.bind.annotation.XmlAttachmentRef;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.bind.annotation.XmlNsForm;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import jakarta.xml.ws.Holder;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.spi.ClassGeneratorClassLoader;
import org.apache.cxf.common.util.ASMHelper;
import org.apache.cxf.common.util.OpcodesProxy;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.jaxws.spi.WrapperClassCreator;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;

public final class WrapperClassGenerator
extends ClassGeneratorClassLoader
implements WrapperClassCreator {
    public static final String DEFAULT_PACKAGE_NAME = "defaultnamespace";
    private static final Logger LOG = LogUtils.getL7dLogger(WrapperClassGenerator.class);
    private final ASMHelper helper;

    public WrapperClassGenerator(Bus bus) {
        super(bus);
        this.helper = bus.getExtension(ASMHelper.class);
    }

    private String getPackageName(Method method) {
        String pkg = PackageUtils.getPackageName(method.getDeclaringClass());
        return pkg.length() == 0 ? DEFAULT_PACKAGE_NAME : pkg;
    }

    private Annotation[] getMethodParameterAnnotations(MessagePartInfo mpi) {
        Annotation[] a = (Annotation[])mpi.getProperty("parameter.annotations");
        if (a != null) {
            return a;
        }
        Annotation[][] paramAnno = (Annotation[][])mpi.getProperty("method.parameters.annotations");
        int index = mpi.getIndex();
        if (paramAnno != null && index < paramAnno.length && index >= 0) {
            return paramAnno[index];
        }
        return null;
    }

    private List<Annotation> getJaxbAnnos(MessagePartInfo mpi) {
        CopyOnWriteArrayList<Annotation> list = new CopyOnWriteArrayList<Annotation>();
        Annotation[] anns = this.getMethodParameterAnnotations(mpi);
        if (anns != null) {
            for (Annotation anno : anns) {
                if (anno.annotationType() != XmlList.class && anno.annotationType() != XmlAttachmentRef.class && anno.annotationType() != XmlJavaTypeAdapter.class && anno.annotationType() != XmlMimeType.class && anno.annotationType() != XmlElement.class && anno.annotationType() != XmlElementWrapper.class) continue;
                list.add(anno);
            }
        }
        return list;
    }

    @Override
    public Set<Class<?>> generate(JaxWsServiceFactoryBean factory, InterfaceInfo interfaceInfo, boolean qualified) {
        LinkedHashSet wrapperBeans = new LinkedHashSet();
        for (OperationInfo opInfo : interfaceInfo.getOperations()) {
            MessageInfo messageInfo;
            Method method;
            if (!opInfo.isUnwrappedCapable() || (method = (Method)opInfo.getProperty("operation.method")) == null) continue;
            MessagePartInfo inf = opInfo.getInput().getFirstMessagePart();
            if (inf.getTypeClass() == null) {
                messageInfo = opInfo.getUnwrappedOperation().getInput();
                this.createWrapperClass(inf, messageInfo, opInfo, method, true, wrapperBeans, factory, interfaceInfo, qualified);
            }
            if ((messageInfo = opInfo.getUnwrappedOperation().getOutput()) == null || (inf = opInfo.getOutput().getFirstMessagePart()).getTypeClass() != null) continue;
            this.createWrapperClass(inf, messageInfo, opInfo, method, false, wrapperBeans, factory, interfaceInfo, qualified);
        }
        return wrapperBeans;
    }

    private void createWrapperClass(MessagePartInfo wrapperPart, MessageInfo messageInfo, OperationInfo op, Method method, boolean isRequest, Set<Class<?>> wrapperBeans, JaxWsServiceFactoryBean factory, InterfaceInfo interfaceInfo, boolean qualified) {
        String pname;
        Class<?> def;
        ASMHelper.ClassWriter cw = this.helper.createClassWriter();
        if (cw == null) {
            LOG.warning(op.getName() + " requires a wrapper bean but problems with ASM has prevented creating one. Operation may not work correctly.");
            return;
        }
        QName wrapperElement = messageInfo.getName();
        boolean anonymous = factory.getAnonymousWrapperTypes();
        String pkg = this.getPackageName(method) + ".jaxws_asm" + (anonymous ? "_an" : "");
        String className = pkg + "." + StringUtils.capitalize(op.getName().getLocalPart());
        if (!isRequest) {
            className = className + "Response";
        }
        if ((def = this.findClass(pname = pkg + ".package-info", method.getDeclaringClass())) == null) {
            this.generatePackageInfo(pname, wrapperElement.getNamespaceURI(), method.getDeclaringClass(), method, interfaceInfo, qualified);
        }
        def = this.findClass(className, method.getDeclaringClass());
        String origClassName = className;
        int count = 0;
        while (def != null) {
            Boolean b = messageInfo.getProperty("parameterized", Boolean.class);
            if (b != null && b.booleanValue()) {
                className = origClassName + ++count;
                def = this.findClass(className, method.getDeclaringClass());
                continue;
            }
            wrapperPart.setTypeClass(def);
            wrapperBeans.add(def);
            return;
        }
        String classFileName = StringUtils.periodToSlashes(className);
        OpcodesProxy opCodes = this.helper.getOpCodes();
        cw.visit(opCodes.V1_5, opCodes.ACC_PUBLIC + opCodes.ACC_SUPER, classFileName, null, "java/lang/Object", null);
        ASMHelper.AnnotationVisitor av0 = cw.visitAnnotation("Ljakarta/xml/bind/annotation/XmlRootElement;", true);
        av0.visit("name", wrapperElement.getLocalPart());
        av0.visit("namespace", wrapperElement.getNamespaceURI());
        av0.visitEnd();
        av0 = cw.visitAnnotation("Ljakarta/xml/bind/annotation/XmlAccessorType;", true);
        av0.visitEnum("value", "Ljakarta/xml/bind/annotation/XmlAccessType;", "FIELD");
        av0.visitEnd();
        av0 = cw.visitAnnotation("Ljakarta/xml/bind/annotation/XmlType;", true);
        if (!anonymous) {
            av0.visit("name", wrapperElement.getLocalPart());
            av0.visit("namespace", wrapperElement.getNamespaceURI());
        } else {
            av0.visit("name", "");
        }
        av0.visitEnd();
        ASMHelper.MethodVisitor mv = cw.visitMethod(opCodes.ACC_PUBLIC, "<init>", "()V", null, null);
        mv.visitCode();
        ASMHelper.Label lbegin = this.helper.createLabel();
        mv.visitLabel(lbegin);
        mv.visitVarInsn(opCodes.ALOAD, 0);
        mv.visitMethodInsn(opCodes.INVOKESPECIAL, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(opCodes.RETURN);
        ASMHelper.Label lend = this.helper.createLabel();
        mv.visitLabel(lend);
        mv.visitLocalVariable("this", "L" + classFileName + ";", null, lbegin, lend, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        for (MessagePartInfo mpi : messageInfo.getMessageParts()) {
            this.generateMessagePart(cw, mpi, method, classFileName, factory);
        }
        cw.visitEnd();
        Class<?> clz = this.loadClass(className, method.getDeclaringClass(), cw.toByteArray());
        wrapperPart.setTypeClass(clz);
        wrapperBeans.add(clz);
    }

    private void generatePackageInfo(String className, String ns, Class<?> clz, Method method, InterfaceInfo interfaceInfo, boolean qualified) {
        ASMHelper.ClassWriter cw = this.helper.createClassWriter();
        String classFileName = StringUtils.periodToSlashes(className);
        OpcodesProxy opCodes = this.helper.getOpCodes();
        cw.visit(opCodes.V1_5, opCodes.ACC_ABSTRACT + opCodes.ACC_INTERFACE, classFileName, null, "java/lang/Object", null);
        boolean q = qualified;
        SchemaInfo si = interfaceInfo.getService().getSchema(ns);
        if (si != null) {
            q = si.isElementFormQualified();
        }
        ASMHelper.AnnotationVisitor av0 = cw.visitAnnotation("Ljakarta/xml/bind/annotation/XmlSchema;", true);
        av0.visit("namespace", ns);
        av0.visitEnum("elementFormDefault", this.helper.getClassCode(XmlNsForm.class), q ? "QUALIFIED" : "UNQUALIFIED");
        av0.visitEnd();
        if (clz.getPackage() != null && clz.getPackage().getAnnotations() != null) {
            for (Annotation ann : clz.getPackage().getAnnotations()) {
                if (ann instanceof XmlJavaTypeAdapters) {
                    av0 = cw.visitAnnotation("Ljakarta/xml/bind/annotation/adapters/XmlJavaTypeAdapters;", true);
                    this.generateXmlJavaTypeAdapters(av0, (XmlJavaTypeAdapters)ann);
                    av0.visitEnd();
                    continue;
                }
                if (!(ann instanceof XmlJavaTypeAdapter)) continue;
                av0 = cw.visitAnnotation("Ljakarta/xml/bind/annotation/adapters/XmlJavaTypeAdapter;", true);
                this.generateXmlJavaTypeAdapter(av0, (XmlJavaTypeAdapter)ann);
                av0.visitEnd();
            }
        }
        cw.visitEnd();
        this.loadClass(className, method.getDeclaringClass(), cw.toByteArray());
    }

    private void generateXmlJavaTypeAdapters(ASMHelper.AnnotationVisitor av, XmlJavaTypeAdapters adapters) {
        ASMHelper.AnnotationVisitor av1 = av.visitArray("value");
        for (XmlJavaTypeAdapter adapter : adapters.value()) {
            ASMHelper.AnnotationVisitor av2 = av1.visitAnnotation(null, "Ljakarta/xml/bind/annotation/adapters/XmlJavaTypeAdapter;");
            this.generateXmlJavaTypeAdapter(av2, adapter);
            av2.visitEnd();
        }
        av1.visitEnd();
    }

    private void generateXmlJavaTypeAdapter(ASMHelper.AnnotationVisitor av, XmlJavaTypeAdapter adapter) {
        if (adapter.value() != null) {
            av.visit("value", this.helper.getType(this.helper.getClassCode(adapter.value())));
        }
        if (adapter.type() != XmlJavaTypeAdapter.DEFAULT.class) {
            av.visit("type", this.helper.getType(this.helper.getClassCode(adapter.type())));
        }
    }

    private void generateMessagePart(ASMHelper.ClassWriter cw, MessagePartInfo mpi, Method method, String className, JaxWsServiceFactoryBean factory) {
        List<Annotation> jaxbAnnos;
        String fieldName;
        ASMHelper.FieldVisitor fv;
        ParameterizedType tp;
        Type genericType;
        if (Boolean.TRUE.equals(mpi.getProperty("messagepart.isheader"))) {
            return;
        }
        OpcodesProxy opCodes = this.helper.getOpCodes();
        String classFileName = StringUtils.periodToSlashes(className);
        String name = mpi.getName().getLocalPart();
        Class clz = mpi.getTypeClass();
        Object obj = mpi.getProperty("rawclass");
        if (obj != null) {
            clz = (Class)obj;
        }
        if ((genericType = (Type)mpi.getProperty("generic.type")) instanceof ParameterizedType && (tp = (ParameterizedType)genericType).getRawType() instanceof Class && Holder.class.isAssignableFrom((Class)tp.getRawType())) {
            genericType = tp.getActualTypeArguments()[0];
        }
        String classCode = this.helper.getClassCode(clz);
        String fieldDescriptor = null;
        if (genericType instanceof ParameterizedType) {
            if (Collection.class.isAssignableFrom(clz) || clz.isArray()) {
                ParameterizedType ptype = (ParameterizedType)genericType;
                Type[] types = ptype.getActualTypeArguments();
                if (types.length > 0) {
                    if (types[0] instanceof Class) {
                        fieldDescriptor = this.helper.getClassCode(genericType);
                    } else if (types[0] instanceof GenericArrayType) {
                        fieldDescriptor = this.helper.getClassCode(genericType);
                    } else if (Collection.class.isAssignableFrom(clz)) {
                        fieldDescriptor = this.helper.getClassCode(genericType);
                    } else if (types[0] instanceof ParameterizedType) {
                        classCode = this.helper.getClassCode(((ParameterizedType)types[0]).getRawType());
                        fieldDescriptor = this.helper.getClassCode(genericType);
                    }
                }
            } else {
                classCode = this.helper.getClassCode(((ParameterizedType)genericType).getRawType());
                fieldDescriptor = this.helper.getClassCode(genericType);
            }
        }
        if (!this.addJAXBAnnotations(fv = cw.visitField(opCodes.ACC_PRIVATE, fieldName = JavaUtils.isJavaKeyword(name) ? JavaUtils.makeNonJavaKeyword(name) : name, classCode, fieldDescriptor, null), jaxbAnnos = this.getJaxbAnnos(mpi), name)) {
            ASMHelper.AnnotationVisitor av0 = fv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlElement;", true);
            av0.visit("name", name);
            if (Boolean.TRUE.equals(factory.isWrapperPartQualified(mpi))) {
                av0.visit("namespace", mpi.getConcreteName().getNamespaceURI());
            }
            if (factory.isWrapperPartNillable(mpi)) {
                av0.visit("nillable", Boolean.TRUE);
            }
            if (factory.getWrapperPartMinOccurs(mpi) == 1L) {
                av0.visit("required", Boolean.TRUE);
            }
            av0.visitEnd();
        }
        fv.visitEnd();
        String methodName = JAXBUtils.nameToIdentifier(name, JAXBUtils.IdentifierType.GETTER);
        ASMHelper.MethodVisitor mv = cw.visitMethod(opCodes.ACC_PUBLIC, methodName, "()" + classCode, fieldDescriptor == null ? null : "()" + fieldDescriptor, null);
        mv.visitCode();
        mv.visitVarInsn(opCodes.ALOAD, 0);
        mv.visitFieldInsn(opCodes.GETFIELD, classFileName, fieldName, classCode);
        mv.visitInsn(this.helper.getType(classCode).getOpcode(opCodes.IRETURN));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        methodName = JAXBUtils.nameToIdentifier(name, JAXBUtils.IdentifierType.SETTER);
        mv = cw.visitMethod(opCodes.ACC_PUBLIC, methodName, "(" + classCode + ")V", fieldDescriptor == null ? null : "(" + fieldDescriptor + ")V", null);
        mv.visitCode();
        mv.visitVarInsn(opCodes.ALOAD, 0);
        ASMHelper.ASMType setType = this.helper.getType(classCode);
        mv.visitVarInsn(setType.getOpcode(opCodes.ILOAD), 1);
        mv.visitFieldInsn(opCodes.PUTFIELD, className, fieldName, classCode);
        mv.visitInsn(opCodes.RETURN);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private boolean addJAXBAnnotations(ASMHelper.FieldVisitor fv, List<Annotation> jaxbAnnos, String name) {
        boolean addedEl = false;
        for (Annotation ann : jaxbAnnos) {
            Annotation el;
            ASMHelper.AnnotationVisitor av0;
            if (ann instanceof XmlMimeType) {
                av0 = fv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlMimeType;", true);
                av0.visit("value", ((XmlMimeType)ann).value());
                av0.visitEnd();
                continue;
            }
            if (ann instanceof XmlJavaTypeAdapter) {
                av0 = fv.visitAnnotation("Ljakarta/xml/bind/annotation/adapters/XmlJavaTypeAdapter;", true);
                this.generateXmlJavaTypeAdapter(av0, (XmlJavaTypeAdapter)ann);
                av0.visitEnd();
                continue;
            }
            if (ann instanceof XmlAttachmentRef) {
                av0 = fv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlAttachmentRef;", true);
                av0.visitEnd();
                continue;
            }
            if (ann instanceof XmlList) {
                av0 = fv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlList;", true);
                av0.visitEnd();
                continue;
            }
            if (ann instanceof XmlElement) {
                addedEl = true;
                el = (XmlElement)ann;
                av0 = fv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlElement;", true);
                if ("##default".equals(el.name())) {
                    av0.visit("name", name);
                } else {
                    av0.visit("name", el.name());
                }
                av0.visit("nillable", el.nillable());
                av0.visit("required", el.required());
                av0.visit("namespace", el.namespace());
                av0.visit("defaultValue", el.defaultValue());
                if (el.type() != XmlElement.DEFAULT.class) {
                    av0.visit("type", el.type());
                }
                av0.visitEnd();
                continue;
            }
            if (!(ann instanceof XmlElementWrapper)) continue;
            el = (XmlElementWrapper)ann;
            av0 = fv.visitAnnotation("Ljakarta/xml/bind/annotation/XmlElementWrapper;", true);
            av0.visit("name", el.name());
            av0.visit("nillable", el.nillable());
            av0.visit("required", el.required());
            av0.visit("namespace", el.namespace());
            av0.visitEnd();
        }
        return addedEl;
    }
}

