/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import javax.annotation.Nonnull;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.ec.ECSupport;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.impl.AbstractDerivationKeyAgreementProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECDHKeyAgreementProcessor
extends AbstractDerivationKeyAgreementProcessor {
    private final Logger log = LoggerFactory.getLogger(ECDHKeyAgreementProcessor.class);

    @Override
    public String getAlgorithm() {
        return "http://www.w3.org/2009/xmlenc11#ECDH-ES";
    }

    @Override
    protected Credential obtainPrivateCredential(@Nonnull Credential publicCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        Credential suppliedCredential = super.obtainPrivateCredential(publicCredential, parameters);
        if (suppliedCredential != null) {
            return suppliedCredential;
        }
        this.log.debug("Found no supplied PrivateCredential in KeyAgreementParameters, generating ephemeral key pair");
        if (!ECPublicKey.class.isInstance(publicCredential.getPublicKey())) {
            throw new KeyAgreementException("Public credential's public key is not an instance of ECPublicKey");
        }
        ECPublicKey publicKey = (ECPublicKey)ECPublicKey.class.cast(publicCredential.getPublicKey());
        try {
            KeyPair privateKeyPair = ECSupport.generateCompatibleKeyPair(publicKey, null);
            return new BasicCredential(privateKeyPair.getPublic(), privateKeyPair.getPrivate());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new KeyAgreementException("Error generating private KeyPair from EC public key", e);
        }
    }

    @Override
    protected byte[] generateAgreementSecret(@Nonnull Credential publicCredential, @Nonnull Credential privateCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        if (!ECPublicKey.class.isInstance(publicCredential.getPublicKey())) {
            throw new KeyAgreementException("Public credential's public key is not an instance of ECPublicKey");
        }
        if (!ECPrivateKey.class.isInstance(privateCredential.getPrivateKey())) {
            throw new KeyAgreementException("Private credential's private key is not an instance of ECPrivateKey");
        }
        ECPublicKey publicKey = (ECPublicKey)ECPublicKey.class.cast(publicCredential.getPublicKey());
        ECPrivateKey privateKey = (ECPrivateKey)ECPrivateKey.class.cast(privateCredential.getPrivateKey());
        try {
            return ECSupport.performKeyAgreement(publicKey, privateKey, null);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new KeyAgreementException("Error generating secret from public and private EC keys", e);
        }
    }
}

