/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.evidence;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.OutputStream;
import java.security.KeyStore;
import network.oxalis.ng.api.evidence.EvidenceFactory;
import network.oxalis.ng.api.lang.EvidenceException;
import network.oxalis.ng.api.outbound.TransmissionResponse;
import network.oxalis.ng.api.transmission.TransmissionResult;
import network.oxalis.ng.api.util.Type;
import network.oxalis.ng.commons.util.OxalisVersion;
import network.oxalis.vefa.peppol.common.api.SimpleIdentifier;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.TransmissionRole;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.EventCode;
import network.oxalis.vefa.peppol.evidence.rem.Evidence;
import network.oxalis.vefa.peppol.evidence.rem.EvidenceTypeInstance;
import network.oxalis.vefa.peppol.evidence.rem.SignedEvidenceWriter;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

@Singleton
@Type(value={"rem"})
public class RemEvidenceFactory
implements EvidenceFactory {
    private static final String ISSUER = String.format("Oxalis %s", OxalisVersion.getVersion());
    private final KeyStore.PrivateKeyEntry privateKeyEntry;

    @Inject
    public RemEvidenceFactory(KeyStore.PrivateKeyEntry privateKeyEntry) {
        this.privateKeyEntry = privateKeyEntry;
    }

    public void write(OutputStream outputStream, TransmissionResult transmissionResult) throws EvidenceException {
        try {
            Evidence evidence = Evidence.newInstance().type(EvidenceTypeInstance.DELIVERY_NON_DELIVERY_TO_RECIPIENT).eventCode(EventCode.DELIVERY).issuer(ISSUER).evidenceIdentifier((SimpleIdentifier)InstanceIdentifier.generateUUID()).timestamp(transmissionResult.getTimestamp()).header(transmissionResult.getHeader()).digest(transmissionResult.getDigest()).messageIdentifier((SimpleIdentifier)transmissionResult.getTransmissionIdentifier()).transportProtocol(transmissionResult.getTransportProtocol()).transmissionRole(transmissionResult instanceof TransmissionResponse ? TransmissionRole.C_2 : TransmissionRole.C_3).originalReceipts(transmissionResult.getReceipts());
            SignedEvidenceWriter.write((OutputStream)outputStream, (KeyStore.PrivateKeyEntry)this.privateKeyEntry, (Evidence)evidence);
        }
        catch (RemEvidenceException | PeppolSecurityException e) {
            throw new EvidenceException(e.getMessage(), e);
        }
    }
}

