/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import network.oxalis.ng.TransmissionParameters;
import network.oxalis.ng.TransmissionResult;
import network.oxalis.ng.api.evidence.EvidenceFactory;
import network.oxalis.ng.api.lang.EvidenceException;
import network.oxalis.ng.api.lang.OxalisTransmissionException;
import network.oxalis.ng.api.outbound.TransmissionRequest;
import network.oxalis.ng.api.outbound.TransmissionResponse;
import network.oxalis.ng.api.outbound.Transmitter;
import network.oxalis.ng.commons.filesystem.FileUtils;
import network.oxalis.ng.commons.tracing.SpanManager;
import network.oxalis.ng.commons.util.ClosableSpan;
import network.oxalis.ng.outbound.transmission.TransmissionRequestBuilder;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmissionTask
implements Callable<TransmissionResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransmissionTask.class);
    private final TransmissionParameters params;
    private final File xmlPayloadFile;
    private final EvidenceFactory evidenceFactory;
    private final SpanManager spanManager;

    public TransmissionTask(TransmissionParameters params, File xmlPayloadFile) {
        this.params = params;
        this.xmlPayloadFile = xmlPayloadFile;
        this.evidenceFactory = params.getOxalisOutboundComponent().getEvidenceFactory();
        this.spanManager = params.getOxalisOutboundComponent().getInjector().getInstance(SpanManager.class);
    }

    @Override
    public TransmissionResult call() throws Exception {
        try (ClosableSpan ignored = this.spanManager.startClosableSpan("standalone");){
            TransmissionResponse transmissionResponse;
            long duration = 0L;
            if (this.params.isUseFactory()) {
                try (InputStream inputStream = Files.newInputStream(this.xmlPayloadFile.toPath(), new OpenOption[0]);){
                    transmissionResponse = this.params.getOxalisOutboundComponent().getTransmissionService().send(inputStream, this.params.getTag());
                }
            } else {
                TransmissionRequest transmissionRequest = this.createTransmissionRequest();
                Transmitter transmitter = this.spanManager.runWithinSpan("get transmitter", () -> this.params.getOxalisOutboundComponent().getTransmitter());
                long start = System.nanoTime();
                TransmissionResponse transmissionResponse2 = this.performTransmission(this.params.getEvidencePath(), transmitter, transmissionRequest);
                long elapsed = System.nanoTime() - start;
                duration = TimeUnit.MILLISECONDS.convert(elapsed, TimeUnit.NANOSECONDS);
                TransmissionResult transmissionResult = new TransmissionResult(duration, transmissionResponse2.getTransmissionIdentifier());
                return transmissionResult;
            }
            TransmissionResult transmissionResult = new TransmissionResult(duration, transmissionResponse.getTransmissionIdentifier());
            return transmissionResult;
        }
    }

    protected TransmissionRequest createTransmissionRequest() {
        return this.spanManager.runWithinSpan("create transmission request", span -> {
            try {
                TransmissionRequestBuilder requestBuilder = this.params.getOxalisOutboundComponent().getTransmissionRequestBuilder();
                requestBuilder.setTransmissionBuilderOverride(true);
                if (this.params.getReceiver().isPresent()) {
                    requestBuilder.receiver(this.params.getReceiver().get());
                }
                if (this.params.getSender().isPresent()) {
                    requestBuilder.sender(this.params.getSender().get());
                }
                if (this.params.getDocType().isPresent()) {
                    requestBuilder.documentType(this.params.getDocType().get());
                }
                if (this.params.getProcessIdentifier().isPresent()) {
                    requestBuilder.processType(this.params.getProcessIdentifier().get());
                }
                try (FileInputStream inputStream = new FileInputStream(this.xmlPayloadFile);){
                    requestBuilder.payLoad(inputStream);
                }
                if (this.params.getEndpoint().isPresent()) {
                    Endpoint endpoint = this.params.getEndpoint().get();
                    requestBuilder.overrideAs4Endpoint(endpoint);
                }
                return requestBuilder.build();
            }
            catch (Exception e) {
                span.setAttribute("exception", String.valueOf(e.getMessage()));
                System.out.println();
                System.out.println("Message failed : " + e.getMessage());
                System.out.println();
                return null;
            }
        });
    }

    protected TransmissionResponse performTransmission(File evidencePath, Transmitter transmitter, TransmissionRequest transmissionRequest) throws OxalisTransmissionException, EvidenceException, IOException {
        try (ClosableSpan ignore = this.spanManager.startClosableSpan("transmission");){
            long start = System.nanoTime();
            TransmissionResponse transmissionResponse = transmitter.transmit(transmissionRequest);
            long elapsed = System.nanoTime() - start;
            long durartionInMs = TimeUnit.MILLISECONDS.convert(elapsed, TimeUnit.NANOSECONDS);
            log.debug(String.format("Message using messageId %s sent to %s using %s was assigned transmissionId %s took %dms\n", transmissionResponse.getHeader().getIdentifier().getIdentifier(), transmissionResponse.getEndpoint().getAddress(), transmissionResponse.getProtocol().getIdentifier(), transmissionResponse.getTransmissionIdentifier(), durartionInMs));
            this.saveEvidence(transmissionResponse, evidencePath);
            TransmissionResponse transmissionResponse2 = transmissionResponse;
            return transmissionResponse2;
        }
    }

    protected void saveEvidence(TransmissionResponse transmissionResponse, File evidencePath) throws IOException, EvidenceException {
        try (ClosableSpan ignore = this.spanManager.startClosableSpan("save evidence");){
            String transIdent = FileUtils.filterString(transmissionResponse.getTransmissionIdentifier().toString());
            File evidenceFile = new File(evidencePath, transIdent + ".receipt.dat");
            try (OutputStream outputStream = Files.newOutputStream(evidenceFile.toPath(), new OpenOption[0]);){
                this.evidenceFactory.write(outputStream, transmissionResponse);
            }
        }
    }
}

