/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.cxf.attachment.As4AttachmentDataSource;
import org.apache.cxf.attachment.As4AttachmentImpl;
import org.apache.cxf.attachment.As4AttachmentUtil;
import org.apache.cxf.attachment.As4DelegatingInputStream;
import org.apache.cxf.attachment.As4LazyAttachmentCollection;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.HeaderSizeExceededException;
import org.apache.cxf.attachment.MimeBodyPartInputStream;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class As4AttachmentDeserializer {
    private static final Pattern CONTENT_TYPE_BOUNDARY_PATTERN = Pattern.compile("boundary=\"?([^\";]*)");
    private static final Pattern INPUT_STREAM_BOUNDARY_PATTERN = Pattern.compile("^--(\\S*)$", 8);
    private static final Logger LOG = LogUtils.getL7dLogger(As4AttachmentDeserializer.class);
    private static final int PUSHBACK_AMOUNT = 2048;
    private boolean lazyLoading = true;
    private PushbackInputStream stream;
    private int createCount;
    private int closedCount;
    private boolean closed;
    private byte[] boundary;
    private String contentType;
    private As4LazyAttachmentCollection attachments;
    private Message message;
    private InputStream body;
    private Set<As4DelegatingInputStream> loaded = new HashSet<As4DelegatingInputStream>();
    private List<String> supportedTypes;
    private int maxHeaderLength = AttachmentDeserializer.DEFAULT_MAX_HEADER_SIZE;
    private List<Attachment> removed = new ArrayList<Attachment>();

    public As4AttachmentDeserializer(Message message) {
        this(message, Collections.singletonList("multipart/related"));
    }

    public As4AttachmentDeserializer(Message message, List<String> supportedTypes) {
        this.message = message;
        this.supportedTypes = supportedTypes;
        this.maxHeaderLength = MessageUtils.getContextualInteger(message, "attachment-max-header-size", AttachmentDeserializer.DEFAULT_MAX_HEADER_SIZE);
    }

    public void initializeAttachments() throws IOException {
        this.initializeRootMessage();
        Object maxCountProperty = this.message.getContextualProperty("attachment-max-count");
        int maxCount = 50;
        if (maxCountProperty != null) {
            maxCount = maxCountProperty instanceof Integer ? (Integer)maxCountProperty : Integer.parseInt((String)maxCountProperty);
        }
        this.attachments = new As4LazyAttachmentCollection(this, maxCount);
        this.message.setAttachments(this.attachments);
    }

    protected void initializeRootMessage() throws IOException {
        this.contentType = (String)this.message.get("Content-Type");
        if (this.contentType == null) {
            throw new IllegalStateException("Content-Type can not be empty!");
        }
        if (this.message.getContent(InputStream.class) == null) {
            throw new IllegalStateException("An InputStream must be provided!");
        }
        if (AttachmentUtil.isTypeSupported(this.contentType.toLowerCase(), this.supportedTypes)) {
            MimeBodyPartInputStream mmps;
            InputStream ins;
            String cs;
            String boundaryString = this.findBoundaryFromContentType(this.contentType);
            if (null == boundaryString) {
                boundaryString = this.findBoundaryFromInputStream();
            }
            if (null == boundaryString) {
                throw new IOException("Couldn't determine the boundary from the message!");
            }
            this.boundary = boundaryString.getBytes("utf-8");
            this.stream = new PushbackInputStream(this.message.getContent(InputStream.class), 2048);
            if (!As4AttachmentDeserializer.readTillFirstBoundary(this.stream, this.boundary)) {
                throw new IOException("Couldn't find MIME boundary: " + boundaryString);
            }
            Map<String, List<String>> ih = this.loadPartHeaders(this.stream);
            this.message.put(AttachmentDeserializer.ATTACHMENT_PART_HEADERS, ih);
            String val2 = As4AttachmentUtil.getHeader(ih, "Content-Type", "; ");
            if (!StringUtils.isEmpty(val2) && !StringUtils.isEmpty(cs = HttpHeaderHelper.findCharset(val2))) {
                this.message.put(Message.ENCODING, HttpHeaderHelper.mapCharset(cs));
            }
            if ((ins = AttachmentUtil.decode(mmps = new MimeBodyPartInputStream(this.stream, this.boundary, 2048), val2 = As4AttachmentUtil.getHeader(ih, "Content-Transfer-Encoding"))) != mmps) {
                ih.remove("Content-Transfer-Encoding");
            }
            this.body = new As4DelegatingInputStream(ins, this);
            ++this.createCount;
            this.message.setContent(InputStream.class, this.body);
        }
    }

    private String findBoundaryFromContentType(String ct) throws IOException {
        Matcher m = CONTENT_TYPE_BOUNDARY_PATTERN.matcher(ct);
        return m.find() ? "--" + m.group(1) : null;
    }

    private String findBoundaryFromInputStream() throws IOException {
        int i;
        InputStream is = this.message.getContent(InputStream.class);
        PushbackInputStream in = new PushbackInputStream(is, 4096);
        byte[] buf = new byte[2048];
        int len = i = in.read(buf);
        while (i > 0 && len < buf.length) {
            i = in.read(buf, len, buf.length - len);
            if (i <= 0) continue;
            len += i;
        }
        String msg = IOUtils.newStringFromBytes(buf, 0, len);
        in.unread(buf, 0, len);
        this.message.setContent(InputStream.class, in);
        Matcher m = INPUT_STREAM_BOUNDARY_PATTERN.matcher(msg);
        return m.find() ? "--" + m.group(1) : null;
    }

    public As4AttachmentImpl readNext() throws IOException {
        this.cacheStreamedAttachments();
        if (this.closed) {
            return null;
        }
        int v = this.stream.read();
        if (v == -1) {
            return null;
        }
        this.stream.unread(v);
        Map<String, List<String>> headers = this.loadPartHeaders(this.stream);
        return (As4AttachmentImpl)this.createAttachment(headers);
    }

    private void cacheStreamedAttachments() throws IOException {
        if (this.body instanceof As4DelegatingInputStream && !((As4DelegatingInputStream)this.body).isClosed()) {
            this.cache((As4DelegatingInputStream)this.body);
        }
        ArrayList<Attachment> atts = new ArrayList<Attachment>(this.attachments.getLoadedAttachments());
        for (Attachment a : atts) {
            DataSource s = a.getDataHandler().getDataSource();
            if (s instanceof As4AttachmentDataSource) {
                As4AttachmentDataSource ads = (As4AttachmentDataSource)s;
                if (ads.isCached()) continue;
                ads.cache(this.message);
                continue;
            }
            if (!(s.getInputStream() instanceof As4DelegatingInputStream)) continue;
            this.cache((As4DelegatingInputStream)s.getInputStream());
        }
    }

    private void cache(As4DelegatingInputStream input) throws IOException {
        if (this.loaded.contains(input)) {
            return;
        }
        this.loaded.add(input);
        InputStream origIn = input.getInputStream();
        try (CachedOutputStream out = new CachedOutputStream();){
            AttachmentUtil.setStreamedAttachmentProperties(this.message, out);
            IOUtils.copy(input, out);
            input.setInputStream(out.getInputStream());
            origIn.close();
        }
    }

    private static boolean readTillFirstBoundary(PushbackInputStream pushbackInStream, byte[] boundary) throws IOException {
        int value = pushbackInStream.read();
        pushbackInStream.unread(value);
        while (value != -1) {
            int boundaryIndex;
            value = pushbackInStream.read();
            if ((byte)value != boundary[0]) continue;
            for (boundaryIndex = 0; value != -1 && boundaryIndex < boundary.length && (byte)value == boundary[boundaryIndex]; ++boundaryIndex) {
                value = pushbackInStream.read();
                if (value != -1) continue;
                throw new IOException("Unexpected End while searching for first Mime Boundary");
            }
            if (boundaryIndex != boundary.length) continue;
            if (value == 13) {
                pushbackInStream.read();
            }
            return true;
        }
        return false;
    }

    private Attachment createAttachment(Map<String, List<String>> headers) throws IOException {
        As4DelegatingInputStream partStream = new As4DelegatingInputStream(new MimeBodyPartInputStream(this.stream, this.boundary, 2048), this);
        ++this.createCount;
        return As4AttachmentUtil.createAttachment(partStream, headers);
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    public void markClosed(As4DelegatingInputStream delegatingInputStream) throws IOException {
        ++this.closedCount;
        if (this.closedCount == this.createCount && !this.attachments.hasNext(false)) {
            int x = this.stream.read();
            while (x != -1) {
                x = this.stream.read();
            }
            this.stream.close();
            this.closed = true;
        }
    }

    public boolean hasNext() throws IOException {
        this.cacheStreamedAttachments();
        if (this.closed) {
            return false;
        }
        int v = this.stream.read();
        if (v == -1) {
            return false;
        }
        this.stream.unread(v);
        return true;
    }

    private Map<String, List<String>> loadPartHeaders(InputStream in) throws IOException {
        StringBuilder buffer = new StringBuilder(128);
        StringBuilder b = new StringBuilder(128);
        TreeMap<String, List<String>> heads = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        while (this.readLine(in, b)) {
            char c = b.charAt(0);
            if (c == ' ' || c == '\t') {
                if (buffer.length() == 0) continue;
                buffer.append("\r\n");
                buffer.append((CharSequence)b);
                continue;
            }
            if (buffer.length() > 0) {
                this.addHeaderLine(heads, buffer);
                buffer.setLength(0);
            }
            buffer.append((CharSequence)b);
        }
        if (buffer.length() > 0) {
            this.addHeaderLine(heads, buffer);
        }
        return heads;
    }

    private boolean readLine(InputStream in, StringBuilder buffer) throws IOException {
        int c;
        if (buffer.length() != 0) {
            buffer.setLength(0);
        }
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13) continue;
            buffer.append((char)c);
            if (buffer.length() <= this.maxHeaderLength) continue;
            LOG.fine("The attachment header size has exceeded the configured parameter: " + this.maxHeaderLength);
            throw new HeaderSizeExceededException();
        }
        return buffer.length() != 0;
    }

    private void addHeaderLine(Map<String, List<String>> heads, StringBuilder line) {
        String name;
        int size = line.length();
        if (size == 0) {
            return;
        }
        int separator = line.indexOf(":");
        String value = "";
        if (separator == -1) {
            name = line.toString().trim();
        } else {
            char ch;
            name = line.substring(0, separator);
            ++separator;
            while (separator < size && ((ch = line.charAt(separator)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n')) {
                ++separator;
            }
            value = line.substring(separator);
        }
        List<String> v = heads.get(name);
        if (v == null) {
            v = new ArrayList<String>(1);
            heads.put(name, v);
        }
        v.add(value);
    }

    public void addRemoved(Attachment remove) {
        this.removed.add(remove);
    }

    @Generated
    public As4LazyAttachmentCollection getAttachments() {
        return this.attachments;
    }

    @Generated
    public List<Attachment> getRemoved() {
        return this.removed;
    }
}

