/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.slf4j;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.event.Level;

public class Slf4jEventSender
implements LogEventSender {
    private Level loggingLevel = Level.INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(LogEvent event) {
        Logger log = this.getLogger(event);
        HashSet<String> keys = new HashSet<String>();
        try {
            this.fillMDC(event, keys);
            this.performLogging(log, MarkerFactory.getMarker(event.getServiceName() != null ? "SOAP" : "REST"), this.getLogMessage(event));
        }
        finally {
            for (String key : keys) {
                MDC.remove(key);
            }
        }
    }

    protected Logger getLogger(LogEvent event) {
        String cat = "org.apache.cxf.services." + event.getPortTypeName().getLocalPart() + "." + event.getType();
        return LoggerFactory.getLogger(cat);
    }

    protected void fillMDC(LogEvent event, Set<String> keys) {
        this.put(keys, "Type", event.getType().toString());
        this.put(keys, "Address", event.getAddress());
        this.put(keys, "HttpMethod", event.getHttpMethod());
        this.put(keys, "Content-Type", event.getContentType());
        this.put(keys, "ResponseCode", event.getResponseCode());
        this.put(keys, "ExchangeId", event.getExchangeId());
        this.put(keys, "MessageId", event.getMessageId());
        if (event.getServiceName() != null) {
            this.put(keys, "ServiceName", this.localPart(event.getServiceName()));
            this.put(keys, "PortName", this.localPart(event.getPortName()));
            this.put(keys, "PortTypeName", this.localPart(event.getPortTypeName()));
        }
        if (event.getFullContentFile() != null) {
            this.put(keys, "FullContentFile", event.getFullContentFile().getAbsolutePath());
        }
        this.put(keys, "Headers", event.getHeaders().toString());
    }

    protected void performLogging(Logger log, Marker marker, String logMessage) {
        if (this.loggingLevel == Level.INFO) {
            log.info(marker, logMessage);
        } else if (this.loggingLevel == Level.DEBUG) {
            log.debug(marker, logMessage);
        } else if (this.loggingLevel == Level.ERROR) {
            log.error(marker, logMessage);
        } else if (this.loggingLevel == Level.TRACE) {
            log.trace(marker, logMessage);
        } else if (this.loggingLevel == Level.WARN) {
            log.warn(marker, logMessage);
        } else {
            log.info(marker, logMessage);
        }
    }

    private String localPart(QName name) {
        return name == null ? null : name.getLocalPart();
    }

    protected String getLogMessage(LogEvent event) {
        return event.getPayload();
    }

    private void put(Set<String> keys, String key, String value) {
        if (value != null) {
            MDC.put(key, value);
            keys.add(key);
        }
    }

    public void setLoggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = Level.valueOf(loggingLevel);
    }
}

