/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore.jcache;

import java.io.Closeable;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreException;
import org.apache.cxf.ws.security.utils.JCacheSupport;

public class JCacheTokenStore
implements TokenStore,
Closeable,
BusLifeCycleListener {
    private final Bus bus;
    private final Cache<String, SecurityToken> cache;
    private final CacheManager cacheManager;
    private final String key;

    public JCacheTokenStore(String key, Bus b, URL configFileURL) throws TokenStoreException {
        this.bus = b;
        if (this.bus != null) {
            b.getExtension(BusLifeCycleManager.class).registerLifeCycleListener(this);
        }
        this.key = key;
        try {
            String template = key;
            if (template.contains("-")) {
                template = key.substring(0, key.lastIndexOf(45));
            }
            CachingProvider cachingProvider = Caching.getCachingProvider();
            this.cacheManager = cachingProvider.getCacheManager(configFileURL.toURI(), SecurityToken.class.getClassLoader());
            this.cache = JCacheSupport.getOrCreate(this.cacheManager, key, String.class, SecurityToken.class);
        }
        catch (Exception e) {
            throw new TokenStoreException(e);
        }
    }

    @Override
    public void add(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty(token.getId())) {
            this.cache.put(token.getId(), token);
        }
    }

    @Override
    public void add(String identifier, SecurityToken token) {
        if (token != null && !StringUtils.isEmpty(identifier)) {
            this.cache.put(identifier, token);
        }
    }

    @Override
    public void remove(String identifier) {
        if (this.cache != null && !StringUtils.isEmpty(identifier)) {
            this.cache.remove(identifier);
        }
    }

    @Override
    public Collection<String> getTokenIdentifiers() {
        if (this.cache == null) {
            return null;
        }
        HashSet<String> keys = new HashSet<String>();
        for (Cache.Entry<String, SecurityToken> entry : this.cache) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public SecurityToken getToken(String identifier) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(identifier);
    }

    @Override
    public synchronized void close() {
        if (!this.cacheManager.isClosed()) {
            this.cacheManager.destroyCache(this.key);
            this.cacheManager.close();
        }
    }

    @Override
    public void initComplete() {
    }

    @Override
    public void preShutdown() {
        this.close();
    }

    @Override
    public void postShutdown() {
        this.close();
    }
}

