/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.cache;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.ehcache.expiry.ExpiryPolicy;

public class EHCacheExpiry
implements ExpiryPolicy<String, EHCacheValue> {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;

    @Override
    public Duration getExpiryForCreation(String s, EHCacheValue ehCacheValue) {
        Instant expiry = ehCacheValue.getExpiry();
        Instant now = Instant.now();
        if (expiry == null || expiry.isBefore(now) || expiry.isAfter(now.plusSeconds(43200L))) {
            return Duration.of(3600L, ChronoUnit.SECONDS);
        }
        return Duration.of(expiry.toEpochMilli() - now.toEpochMilli(), ChronoUnit.MILLIS);
    }

    @Override
    public Duration getExpiryForAccess(String s, Supplier<? extends EHCacheValue> supplier) {
        return null;
    }

    @Override
    public Duration getExpiryForUpdate(String s, Supplier<? extends EHCacheValue> supplier, EHCacheValue ehCacheValue) {
        return null;
    }
}

