/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.Header;
import org.apache.wss4j.policy.model.SignedParts;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.policy.stax.DummyPolicyAsserter;
import org.apache.wss4j.policy.stax.PolicyAsserter;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.securityEvent.SignedPartSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.utils.WSSUtils;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class SignedPartsAssertionState
extends AssertionState
implements Assertable {
    private int attachmentCount;
    private int signedAttachmentCount;
    private boolean signedAttachmentRequired;
    private PolicyAsserter policyAsserter;
    private final boolean soap12;

    public SignedPartsAssertionState(AbstractSecurityAssertion assertion, PolicyAsserter policyAsserter, boolean asserted, int attachmentCount, boolean soap12) {
        super(assertion, asserted);
        this.attachmentCount = attachmentCount;
        this.policyAsserter = policyAsserter;
        if (this.policyAsserter == null) {
            this.policyAsserter = new DummyPolicyAsserter();
        }
        if (asserted) {
            policyAsserter.assertPolicy(this.getAssertion());
        }
        this.soap12 = soap12;
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.SIGNED_PART};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        List<QName> bodyPath;
        SignedPartSecurityEvent signedPartSecurityEvent = (SignedPartSecurityEvent)securityEvent;
        SignedParts signedParts = (SignedParts)this.getAssertion();
        if (signedParts.getAttachments() != null) {
            this.signedAttachmentRequired = true;
            if (signedPartSecurityEvent.isAttachment()) {
                ++this.signedAttachmentCount;
                this.setAsserted(true);
                this.policyAsserter.assertPolicy(this.getAssertion());
                return true;
            }
        }
        List<QName> list = bodyPath = this.soap12 ? WSSConstants.SOAP_12_BODY_PATH : WSSConstants.SOAP_11_BODY_PATH;
        if (signedParts.isBody() && WSSUtils.pathMatches(bodyPath, signedPartSecurityEvent.getElementPath())) {
            if (signedPartSecurityEvent.isSigned()) {
                this.setAsserted(true);
                this.policyAsserter.assertPolicy(this.getAssertion());
                return true;
            }
            this.setAsserted(false);
            this.setErrorMessage("Element " + WSSUtils.pathAsString(signedPartSecurityEvent.getElementPath()) + " must be signed");
            this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            return false;
        }
        if (signedParts.isSignAllHeaders()) {
            if (signedPartSecurityEvent.isSigned()) {
                this.setAsserted(true);
                this.policyAsserter.assertPolicy(this.getAssertion());
                return true;
            }
            this.setAsserted(false);
            this.setErrorMessage("Element " + WSSUtils.pathAsString(signedPartSecurityEvent.getElementPath()) + " must be signed");
            this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            return false;
        }
        for (int i = 0; i < signedParts.getHeaders().size(); ++i) {
            Header header = signedParts.getHeaders().get(i);
            QName headerQName = new QName(header.getNamespace(), header.getName() == null ? "" : header.getName());
            LinkedList<QName> headerPath = new LinkedList<QName>();
            if (this.soap12) {
                headerPath.addAll(WSSConstants.SOAP_12_HEADER_PATH);
            } else {
                headerPath.addAll(WSSConstants.SOAP_11_HEADER_PATH);
            }
            headerPath.add(headerQName);
            if (!WSSUtils.pathMatches(headerPath, signedPartSecurityEvent.getElementPath(), header.getName() == null)) continue;
            if (signedPartSecurityEvent.isSigned()) {
                this.setAsserted(true);
                this.policyAsserter.assertPolicy(this.getAssertion());
                return true;
            }
            this.setAsserted(false);
            this.setErrorMessage("Element " + WSSUtils.pathAsString(signedPartSecurityEvent.getElementPath()) + " must be signed");
            this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            return false;
        }
        this.policyAsserter.assertPolicy(this.getAssertion());
        return true;
    }

    @Override
    public boolean isAsserted() {
        if (this.signedAttachmentRequired && this.signedAttachmentCount < this.attachmentCount) {
            return false;
        }
        return super.isAsserted();
    }
}

