/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action;

import com.google.common.base.Predicates;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;

public abstract class AbstractHandlerDelegatingProfileAction<DelegateType extends MessageHandler>
extends AbstractConditionalProfileAction {
    @Nonnull
    private static final ParentProfileRequestContextLookup<MessageContext> PRC_LOOKUP = new ParentProfileRequestContextLookup();
    @Nonnull
    private DelegateType delegate;
    @Nonnull
    private ContextDataLookupFunction<ProfileRequestContext, MessageContext> messageContextLookup;
    @Nullable
    private String errorEvent;

    public AbstractHandlerDelegatingProfileAction(@Nonnull Class<DelegateType> delegateClass, @Nonnull ContextDataLookupFunction<ProfileRequestContext, MessageContext> lookup2) {
        Constraint.isNotNull(delegateClass, "Delegate class may not be null");
        try {
            this.delegate = (MessageHandler)delegateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.messageContextLookup = Constraint.isNotNull(lookup2, "MessageContext lookup function may not be null");
    }

    public AbstractHandlerDelegatingProfileAction(@Nonnull DelegateType delegateInstance, @Nonnull ContextDataLookupFunction<ProfileRequestContext, MessageContext> lookup2) {
        this.delegate = (MessageHandler)Constraint.isNotNull(delegateInstance, "Delegate instance may not be null");
        this.messageContextLookup = Constraint.isNotNull(lookup2, "MessageContext lookup function may not be null");
    }

    public void setErrorEvent(@Nullable String event) {
        this.errorEvent = StringSupport.trimOrNull(event);
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        if (this.delegate != null && this.delegate instanceof DestructableComponent) {
            ((DestructableComponent)this.delegate).destroy();
        }
    }

    @Nonnull
    protected DelegateType getDelegate() {
        return this.delegate;
    }

    @Nullable
    protected Predicate<MessageContext> adapt(@Nullable Predicate<ProfileRequestContext> predicate) {
        if (predicate == null) {
            return null;
        }
        return Predicates.compose(predicate::test, arg_0 -> PRC_LOOKUP.apply(arg_0));
    }

    @Nullable
    protected <T> Function<MessageContext, T> adapt(@Nullable Function<ProfileRequestContext, T> function) {
        if (function == null) {
            return null;
        }
        return function.compose(PRC_LOOKUP);
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext messageContext = (MessageContext)this.messageContextLookup.apply((Object)profileRequestContext);
        if (messageContext == null) {
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return;
        }
        try {
            this.delegate.invoke(messageContext);
            ActionSupport.buildProceedEvent(profileRequestContext);
        }
        catch (MessageHandlerException e) {
            if (this.errorEvent != null) {
                ActionSupport.buildEvent(profileRequestContext, this.errorEvent);
            }
            ActionSupport.buildEvent(profileRequestContext, "MessageProcessingError");
        }
    }
}

