/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAttributesPredicate
implements Predicate<EntityDescriptor> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EntityAttributesPredicate.class);
    private final boolean trimTags;
    private final boolean matchAll;
    @Nonnull
    @NonnullElements
    private final Collection<Candidate> candidateSet;

    public EntityAttributesPredicate(@Nonnull @ParameterName(name="candidates") @NonnullElements Collection<Candidate> candidates) {
        this.candidateSet = List.copyOf(Constraint.isNotNull(candidates, "Candidate collection cannot be null"));
        this.trimTags = true;
        this.matchAll = false;
    }

    public EntityAttributesPredicate(@Nonnull @ParameterName(name="candidates") @NonnullElements Collection<Candidate> candidates, @ParameterName(name="trim") boolean trim) {
        this.candidateSet = List.copyOf(Constraint.isNotNull(candidates, "Candidate collection cannot be null"));
        this.trimTags = trim;
        this.matchAll = false;
    }

    public EntityAttributesPredicate(@Nonnull @ParameterName(name="candidates") @NonnullElements Collection<Candidate> candidates, @ParameterName(name="trim") boolean trim, @ParameterName(name="all") boolean all) {
        this.candidateSet = List.copyOf(Constraint.isNotNull(candidates, "Candidate collection cannot be null"));
        this.trimTags = trim;
        this.matchAll = all;
    }

    public boolean getTrimTags() {
        return this.trimTags;
    }

    public boolean getMatchAll() {
        return this.matchAll;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Collection<Candidate> getCandidates() {
        return this.candidateSet;
    }

    @Override
    public boolean test(@Nullable EntityDescriptor input) {
        List<XMLObject> children;
        if (input == null) {
            return false;
        }
        ArrayList<Attribute> entityAttributes = null;
        Extensions exts = input.getExtensions();
        if (exts != null && !(children = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty() && children.get(0) instanceof EntityAttributes) {
            if (entityAttributes == null) {
                entityAttributes = new ArrayList<Attribute>();
            }
            entityAttributes.addAll(((EntityAttributes)children.get(0)).getAttributes());
        }
        for (EntitiesDescriptor group = (EntitiesDescriptor)input.getParent(); group != null; group = (EntitiesDescriptor)group.getParent()) {
            List<XMLObject> children2;
            exts = group.getExtensions();
            if (exts == null || (children2 = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty() || !(children2.get(0) instanceof EntityAttributes)) continue;
            if (entityAttributes == null) {
                entityAttributes = new ArrayList();
            }
            entityAttributes.addAll(((EntityAttributes)children2.get(0)).getAttributes());
        }
        if (entityAttributes == null || entityAttributes.isEmpty()) {
            this.log.trace("No Entity Attributes found for {}", (Object)input.getEntityID());
            return false;
        }
        this.log.trace("Checking for match against {} Entity Attributes for {}", (Object)entityAttributes.size(), (Object)input.getEntityID());
        EntityAttributesMatcher matcher = new EntityAttributesMatcher(entityAttributes);
        if (this.matchAll) {
            return Iterables.all(this.candidateSet, matcher::test);
        }
        return Iterables.tryFind(this.candidateSet, matcher::test).isPresent();
    }

    private class EntityAttributesMatcher
    implements Predicate<Candidate> {
        private final Collection<Attribute> attributes;

        public EntityAttributesMatcher(Collection<Attribute> attrs) {
            this.attributes = Constraint.isNotNull(attrs, "Extension attributes cannot be null");
        }

        @Override
        public boolean test(@Nonnull Candidate input) {
            List<String> tagvals = input.values;
            List<Pattern> tagexps = input.regexps;
            boolean[] valflags = new boolean[tagvals.size()];
            boolean[] expflags = new boolean[tagexps.size()];
            for (Attribute a : this.attributes) {
                int tagindex;
                if (a.getName() == null || !a.getName().equals(input.getName()) || input.getNameFormat() != null && !input.getNameFormat().equals(a.getNameFormat())) continue;
                List<String> attributeValues = this.getPossibleAttributeValuesAsStrings(a);
                block1: for (tagindex = 0; tagindex < tagvals.size(); ++tagindex) {
                    String tagvalstr = tagvals.get(tagindex);
                    for (String cvalstr : attributeValues) {
                        if (tagvalstr == null || cvalstr == null) continue;
                        if (tagvalstr.equals(cvalstr)) {
                            EntityAttributesPredicate.this.log.trace("Matched Entity Attribute ({}:{}) value {}", a.getNameFormat(), a.getName(), tagvalstr);
                            valflags[tagindex] = true;
                            continue block1;
                        }
                        if (!EntityAttributesPredicate.this.trimTags || !tagvalstr.equals(cvalstr.trim())) continue;
                        EntityAttributesPredicate.this.log.trace("Matched Entity Attribute ({}:{}) value {}", a.getNameFormat(), a.getName(), tagvalstr);
                        valflags[tagindex] = true;
                        continue block1;
                    }
                }
                block3: for (tagindex = 0; tagindex < tagexps.size(); ++tagindex) {
                    for (String cvalstr : attributeValues) {
                        if (tagexps.get(tagindex) == null || cvalstr == null || !tagexps.get(tagindex).matcher(cvalstr).matches()) continue;
                        EntityAttributesPredicate.this.log.trace("Matched Entity Attribute ({}:{}) value {}", a.getNameFormat(), a.getName(), cvalstr);
                        expflags[tagindex] = true;
                        continue block3;
                    }
                }
            }
            for (Object flag : (Object)valflags) {
                if (flag != false) continue;
                return false;
            }
            for (Object flag : (Object)expflags) {
                if (flag != false) continue;
                return false;
            }
            return true;
        }

        @Nonnull
        List<String> getPossibleAttributeValuesAsStrings(@Nonnull Attribute attribute) {
            List<XMLObject> cvals = attribute.getAttributeValues();
            ArrayList<String> result = new ArrayList<String>(cvals.size() * 2);
            for (XMLObject cval : cvals) {
                result.addAll(this.xmlObjectToStrings(cval));
            }
            return result;
        }

        @Nullable
        private List<String> xmlObjectToStrings(@Nonnull XMLObject object) {
            XSAny wc;
            String toMatch = null;
            String toMatchAlt = null;
            if (object instanceof XSString) {
                toMatch = ((XSString)object).getValue();
            } else if (object instanceof XSURI) {
                toMatch = ((XSURI)object).getURI();
            } else if (object instanceof XSBoolean) {
                toMatch = ((XSBoolean)object).getValue().getValue() != false ? "1" : "0";
                toMatchAlt = ((XSBoolean)object).getValue().getValue() != false ? "true" : "false";
            } else if (object instanceof XSInteger) {
                toMatch = ((XSInteger)object).getValue().toString();
            } else if (object instanceof XSDateTime) {
                Instant dt = ((XSDateTime)object).getValue();
                if (dt != null) {
                    toMatch = DOMTypeSupport.instantToString(dt);
                }
            } else if (object instanceof XSBase64Binary) {
                toMatch = ((XSBase64Binary)object).getValue();
            } else if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
                toMatch = wc.getTextContent();
            }
            if (toMatchAlt != null) {
                return List.of(toMatch, toMatchAlt);
            }
            if (toMatch != null) {
                return Collections.singletonList(toMatch);
            }
            EntityAttributesPredicate.this.log.warn("Unrecognized XMLObject type ({}), unable to convert to a string for comparison", (Object)object.getClass().getName());
            return Collections.emptyList();
        }
    }

    public static class Candidate {
        @Nonnull
        @NotEmpty
        private final String nam;
        @Nullable
        private final String nameFormat;
        @Nonnull
        @NonnullElements
        private List<String> values;
        @Nonnull
        @NonnullElements
        private List<Pattern> regexps;

        public Candidate(@Nonnull @ParameterName(name="name") @NotEmpty String name) {
            this.nam = Constraint.isNotNull(StringSupport.trimOrNull(name), "Attribute Name cannot be null or empty");
            this.nameFormat = null;
            this.values = Collections.emptyList();
            this.regexps = Collections.emptyList();
        }

        public Candidate(@Nonnull @ParameterName(name="name") @NotEmpty String name, @Nullable @ParameterName(name="format") String format) {
            this.nam = Constraint.isNotNull(StringSupport.trimOrNull(name), "Attribute Name cannot be null or empty");
            this.nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified".equals(format) ? null : StringSupport.trimOrNull(format);
            this.values = Collections.emptyList();
            this.regexps = Collections.emptyList();
        }

        @Nonnull
        @NotEmpty
        public String getName() {
            return this.nam;
        }

        @Nullable
        public String getNameFormat() {
            return this.nameFormat;
        }

        @Nonnull
        @NonnullElements
        @Unmodifiable
        @NotLive
        public List<String> getValues() {
            return this.values;
        }

        public void setValues(@Nonnull @NonnullElements Collection<String> vals) {
            this.values = List.copyOf(Constraint.isNotNull(vals, "Values collection cannot be null"));
        }

        @Nonnull
        @NonnullElements
        @Unmodifiable
        @NotLive
        public List<Pattern> getRegexps() {
            return this.regexps;
        }

        public void setRegexps(@Nonnull @NonnullElements Collection<Pattern> exps) {
            this.regexps = List.copyOf(Constraint.isNotNull(exps, "Regular expressions collection cannot be null"));
        }
    }
}

