/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.MediaTypeSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSource;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicMetadataResolver;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractDynamicHTTPMetadataResolver
extends AbstractDynamicMetadataResolver {
    public static final String[] DEFAULT_CONTENT_TYPES = new String[]{"application/samlmetadata+xml", "application/xml", "text/xml"};
    public static final String MDC_ATTRIB_CURRENT_REQUEST_URI = AbstractDynamicHTTPMetadataResolver.class.getName() + ".currentRequestURI";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPMetadataResolver.class);
    @Nonnull
    private HttpClient httpClient;
    @NonnullAfterInit
    private List<String> supportedContentTypes;
    @NonnullAfterInit
    private String supportedContentTypesValue;
    @NonnullAfterInit
    private Set<MediaType> supportedMediaTypes;
    @Nonnull
    private ResponseHandler<XMLObject> responseHandler;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    public AbstractDynamicHTTPMetadataResolver(@Nonnull HttpClient client) {
        this(null, client);
    }

    public AbstractDynamicHTTPMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull HttpClient client) {
        super(backgroundTaskTimer);
        this.httpClient = Constraint.isNotNull(client, "HttpClient may not be null");
        this.responseHandler = new BasicMetadataResponseHandler();
    }

    @Nullable
    protected HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.httpClientSecurityParameters = params;
    }

    @NonnullAfterInit
    @NotLive
    @Unmodifiable
    protected Set<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    @NonnullAfterInit
    @NotLive
    @Unmodifiable
    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(@Nullable List<String> types) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.supportedContentTypes = types == null ? Collections.emptyList() : StringSupport.normalizeStringCollection(types).stream().filter(s -> s != null).map(String::toLowerCase).collect(Collectors.toUnmodifiableList());
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        if (this.getSupportedContentTypes() == null) {
            this.setSupportedContentTypes(Arrays.asList(DEFAULT_CONTENT_TYPES));
        }
        if (!this.getSupportedContentTypes().isEmpty()) {
            this.supportedContentTypesValue = StringSupport.listToStringValue(this.getSupportedContentTypes(), ", ");
            this.supportedMediaTypes = new LazySet<MediaType>();
            for (String contentType : this.getSupportedContentTypes()) {
                this.supportedMediaTypes.add(MediaType.parse(contentType));
            }
        } else {
            this.supportedMediaTypes = Collections.emptySet();
        }
        this.log.debug("{} Supported content types are: {}", (Object)this.getLogPrefix(), (Object)this.getSupportedContentTypes());
    }

    @Override
    protected void doDestroy() {
        this.httpClient = null;
        this.httpClientSecurityParameters = null;
        this.supportedContentTypes = null;
        this.supportedContentTypesValue = null;
        this.supportedMediaTypes = null;
        super.doDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected XMLObject fetchFromOriginSource(@Nonnull CriteriaSet criteria) throws IOException {
        HttpUriRequest request = this.buildHttpRequest(criteria);
        if (request == null) {
            this.log.debug("{} Could not build request based on input criteria, unable to query", (Object)this.getLogPrefix());
            return null;
        }
        HttpClientContext context = this.buildHttpClientContext(request);
        try {
            MDC.put(MDC_ATTRIB_CURRENT_REQUEST_URI, request.getURI().toString());
            XMLObject result = (XMLObject)this.httpClient.execute(request, this.responseHandler, (HttpContext)context);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated(context, request.getURI().getScheme());
            XMLObject xMLObject = result;
            return xMLObject;
        }
        finally {
            MDC.remove(MDC_ATTRIB_CURRENT_REQUEST_URI);
        }
    }

    @Nullable
    protected HttpUriRequest buildHttpRequest(@Nonnull CriteriaSet criteria) {
        String url = this.buildRequestURL(criteria);
        this.log.debug("{} Built request URL of: {}", (Object)this.getLogPrefix(), (Object)url);
        if (url == null) {
            this.log.debug("{} Could not construct request URL from input criteria, unable to query", (Object)this.getLogPrefix());
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        if (!Strings.isNullOrEmpty(this.supportedContentTypesValue)) {
            getMethod.addHeader("Accept", this.supportedContentTypesValue);
        }
        return getMethod;
    }

    @Nullable
    protected abstract String buildRequestURL(@Nonnull CriteriaSet var1);

    protected HttpClientContext buildHttpClientContext(@Nonnull HttpUriRequest request) {
        HttpClientContext context = HttpClientContext.create();
        HttpClientSecuritySupport.marshalSecurityParameters(context, this.httpClientSecurityParameters, true);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria(context, request);
        return context;
    }

    public class BasicMetadataResponseHandler
    implements ResponseHandler<XMLObject> {
        public XMLObject handleResponse(@Nonnull HttpResponse response) throws IOException {
            XMLObject xMLObject;
            int httpStatusCode = response.getStatusLine().getStatusCode();
            String currentRequestURI = MDC.get(MDC_ATTRIB_CURRENT_REQUEST_URI);
            if (httpStatusCode == 304) {
                AbstractDynamicHTTPMetadataResolver.this.log.debug("{} Metadata document from '{}' has not changed since last retrieval", (Object)AbstractDynamicHTTPMetadataResolver.this.getLogPrefix(), (Object)currentRequestURI);
                return null;
            }
            if (httpStatusCode != 200) {
                AbstractDynamicHTTPMetadataResolver.this.log.warn("{} Non-ok status code '{}' returned from remote metadata source: {}", AbstractDynamicHTTPMetadataResolver.this.getLogPrefix(), httpStatusCode, currentRequestURI);
                return null;
            }
            try {
                this.validateHttpResponse(response);
            }
            catch (ResolverException e) {
                AbstractDynamicHTTPMetadataResolver.this.log.error("{} Problem validating dynamic metadata HTTP response", (Object)AbstractDynamicHTTPMetadataResolver.this.getLogPrefix(), (Object)e);
                return null;
            }
            InputStream ins = response.getEntity().getContent();
            byte[] source = ByteStreams.toByteArray(ins);
            ByteArrayInputStream bais = new ByteArrayInputStream(source);
            try {
                XMLObject xmlObject = AbstractDynamicHTTPMetadataResolver.this.unmarshallMetadata(bais);
                xmlObject.getObjectMetadata().put(new XMLObjectSource(source));
                xMLObject = xmlObject;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bais.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | UnmarshallingException e) {
                    AbstractDynamicHTTPMetadataResolver.this.log.error("{} Error unmarshalling HTTP response stream", (Object)AbstractDynamicHTTPMetadataResolver.this.getLogPrefix(), (Object)e);
                    return null;
                }
            }
            bais.close();
            return xMLObject;
        }

        protected void validateHttpResponse(@Nonnull HttpResponse response) throws ResolverException {
            if (!AbstractDynamicHTTPMetadataResolver.this.getSupportedMediaTypes().isEmpty()) {
                String contentTypeValue = null;
                Header contentType = response.getEntity().getContentType();
                if (contentType != null && contentType.getValue() != null) {
                    contentTypeValue = StringSupport.trimOrNull(contentType.getValue());
                }
                AbstractDynamicHTTPMetadataResolver.this.log.debug("{} Saw raw Content-Type from response header '{}'", (Object)AbstractDynamicHTTPMetadataResolver.this.getLogPrefix(), (Object)contentTypeValue);
                if (!MediaTypeSupport.validateContentType(contentTypeValue, AbstractDynamicHTTPMetadataResolver.this.getSupportedMediaTypes(), true, false)) {
                    throw new ResolverException("HTTP response specified an unsupported Content-Type MIME type: " + contentTypeValue);
                }
            }
        }
    }
}

