/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.net.UrlEscapers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateRequestURLBuilder
implements Function<CriteriaSet, String> {
    public static final String CONTEXT_KEY_ENTITY_ID = "entityID";
    private final Logger log = LoggerFactory.getLogger(TemplateRequestURLBuilder.class);
    private Template template;
    private String templateText;
    private Function<String, String> transformer;
    private EncodingStyle entityIDEncodingStyle;

    public TemplateRequestURLBuilder(@Nonnull VelocityEngine engine, @Nonnull @NotEmpty String templateString, @Nullable EncodingStyle encodingStyle) {
        this(engine, templateString, encodingStyle, null, StandardCharsets.US_ASCII);
    }

    public TemplateRequestURLBuilder(@Nonnull VelocityEngine engine, @Nonnull @NotEmpty String templateString, @Nullable EncodingStyle encodingStyle, @Nullable Function<String, String> transform) {
        this(engine, templateString, encodingStyle, transform, StandardCharsets.US_ASCII);
    }

    public TemplateRequestURLBuilder(@Nonnull VelocityEngine engine, @Nonnull @NotEmpty String templateString, EncodingStyle encodingStyle, @Nullable Function<String, String> transform, @Nullable Charset charSet) {
        Constraint.isNotNull(engine, "VelocityEngine was null");
        String trimmedTemplate = StringSupport.trimOrNull(templateString);
        this.templateText = Constraint.isNotNull(trimmedTemplate, "Template string was null or empty");
        this.transformer = transform;
        this.template = charSet != null ? Template.fromTemplate(engine, trimmedTemplate, charSet) : Template.fromTemplate(engine, trimmedTemplate);
        this.entityIDEncodingStyle = encodingStyle != null ? encodingStyle : EncodingStyle.none;
    }

    @Override
    @Nullable
    public String apply(@Nullable CriteriaSet criteria) {
        Constraint.isNotNull(criteria, "Criteria was null");
        if (!criteria.contains(EntityIdCriterion.class)) {
            this.log.trace("Criteria did not contain entity ID, unable to build request URL");
            return null;
        }
        String entityID = criteria.get(EntityIdCriterion.class).getEntityId();
        this.log.debug("Saw input entityID '{}'", (Object)entityID);
        if (this.transformer != null) {
            entityID = this.transformer.apply(entityID);
            this.log.debug("Transformed entityID is '{}'", (Object)entityID);
            if (entityID == null) {
                this.log.debug("Transformed entityID was null");
                return null;
            }
        }
        VelocityContext context = new VelocityContext();
        switch (this.entityIDEncodingStyle) {
            case none: {
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)entityID);
                break;
            }
            case form: {
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)UrlEscapers.urlFormParameterEscaper().escape(entityID));
                break;
            }
            case path: {
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)UrlEscapers.urlPathSegmentEscaper().escape(entityID));
                break;
            }
            case fragment: {
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)UrlEscapers.urlFragmentEscaper().escape(entityID));
                break;
            }
            default: {
                this.log.warn("An unsupported EncodingStyle value was seen, treating as 'none': {}", (Object)this.entityIDEncodingStyle);
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)entityID);
            }
        }
        try {
            String result = this.template.merge((Context)context);
            this.log.debug("From entityID '{}' and template text '{}', built request URL: {}", entityID, this.templateText, result);
            return result;
        }
        catch (Throwable t) {
            this.log.error("Encountered fatal error attempting to build request URL", t);
            return null;
        }
    }

    public static enum EncodingStyle {
        none,
        form,
        path,
        fragment;

    }
}

