/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationProcessingData;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.impl.DefaultAssertionValidationContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAssertions
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateAssertions.class);
    private boolean invalidFatal;
    @Nullable
    private SAML20AssertionValidator assertionValidator;
    @Nullable
    private Function<Pair<ProfileRequestContext, Assertion>, SAML20AssertionValidator> assertionValidatorLookup;
    @NonnullAfterInit
    private Function<AssertionValidationInput, ValidationContext> validationContextBuilder;
    @Nonnull
    private Function<ProfileRequestContext, List<Assertion>> assertionResolver;
    private List<Assertion> assertions;

    public ValidateAssertions() {
        this.setInvalidFatal(true);
        this.setValidationContextBuilder(new DefaultAssertionValidationContextBuilder());
        this.setAssertionResolver(new DefaultAssertionResolver());
    }

    @Nonnull
    public Function<ProfileRequestContext, List<Assertion>> getAssertionResolver() {
        return this.assertionResolver;
    }

    public void setAssertionResolver(@Nonnull Function<ProfileRequestContext, List<Assertion>> function) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.assertionResolver = function;
    }

    @NonnullAfterInit
    public Function<AssertionValidationInput, ValidationContext> getValidationContextBuilder() {
        return this.validationContextBuilder;
    }

    public void setValidationContextBuilder(@Nonnull Function<AssertionValidationInput, ValidationContext> builder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.validationContextBuilder = builder;
    }

    public boolean isInvalidFatal() {
        return this.invalidFatal;
    }

    public void setInvalidFatal(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.invalidFatal = flag;
    }

    @Nullable
    public SAML20AssertionValidator getAssertionValidator() {
        return this.assertionValidator;
    }

    public void setAssertionValidator(@Nullable SAML20AssertionValidator validator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.assertionValidator = validator;
    }

    @Nullable
    public Function<Pair<ProfileRequestContext, Assertion>, SAML20AssertionValidator> getAssertionValidatorLookup() {
        return this.assertionValidatorLookup;
    }

    public void setAssertionValidatorLookup(@Nullable Function<Pair<ProfileRequestContext, Assertion>, SAML20AssertionValidator> function) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.assertionValidatorLookup = function;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getAssertionResolver() == null) {
            throw new ComponentInitializationException("Assertion resolver function cannot be null");
        }
        if (this.getValidationContextBuilder() == null) {
            throw new ComponentInitializationException("ValidationContext builder cannot be null");
        }
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest cannot be null");
        }
        if (this.getAssertionValidator() == null) {
            if (this.getAssertionValidatorLookup() == null) {
                throw new ComponentInitializationException("Both Assertion validator and lookup function were null");
            }
            this.log.info("{} Assertion validator is null, must be resovleable via the lookup function", (Object)this.getLogPrefix());
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.assertions = this.getAssertionResolver().apply(profileRequestContext);
        if (this.assertions == null || this.assertions.isEmpty()) {
            this.log.info("{} Profile context contained no Assertions to validate. Skipping further processing", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileContext) {
        boolean sawNonValid = false;
        for (Assertion assertion : this.assertions) {
            SAML20AssertionValidator validator = this.resolveValidator(profileContext, assertion);
            if (validator == null) {
                this.log.warn("{} No SAML20AssertionValidator was available, terminating", (Object)this.getLogPrefix());
                ActionSupport.buildEvent(profileContext, "UnableToValidateAssertion");
                return;
            }
            try {
                ValidationContext validationContext = this.buildValidationContext(profileContext, assertion);
                ValidationResult validationResult = validator.validate(assertion, validationContext);
                if (validationResult != ValidationResult.VALID) {
                    sawNonValid = true;
                }
                this.processResult(validationContext, validationResult, assertion, profileContext);
            }
            catch (Throwable t) {
                this.log.warn("{} There was a problem determining Assertion validity", (Object)this.getLogPrefix(), (Object)t);
                ActionSupport.buildEvent(profileContext, "UnableToValidateAssertion");
                return;
            }
        }
        if (sawNonValid && this.isInvalidFatal()) {
            ActionSupport.buildEvent(profileContext, "AssertionInvalid");
        } else {
            ActionSupport.buildProceedEvent(profileContext);
        }
    }

    protected void processResult(@Nonnull ValidationContext validationContext, @Nonnull ValidationResult validationResult, @Nonnull Assertion assertion, @Nonnull ProfileRequestContext profileContext) {
        this.log.debug("{} Assertion validation result was: {}", (Object)this.getLogPrefix(), (Object)validationResult);
        if (validationResult != ValidationResult.VALID) {
            this.log.info("{} Assertion validation failure msg was: {}", (Object)this.getLogPrefix(), (Object)validationContext.getValidationFailureMessage());
        }
        assertion.getObjectMetadata().put(new ValidationProcessingData(validationContext, validationResult));
    }

    @Nullable
    protected SAML20AssertionValidator resolveValidator(@Nonnull ProfileRequestContext profileContext, @Nonnull Assertion assertion) {
        if (this.getAssertionValidatorLookup() != null) {
            this.log.debug("{} Attempting to resolve SAML 2 Assertion validator via lookup function", (Object)this.getLogPrefix());
            SAML20AssertionValidator validator = this.getAssertionValidatorLookup().apply(new Pair<ProfileRequestContext, Assertion>(profileContext, assertion));
            if (validator != null) {
                this.log.debug("{} Resolved SAML 2 Assertion validator via lookup function", (Object)this.getLogPrefix());
                return validator;
            }
        }
        if (this.getAssertionValidator() != null) {
            this.log.debug("{} Resolved locally configured SAML 2 Assertion validator", (Object)this.getLogPrefix());
            return this.getAssertionValidator();
        }
        this.log.debug("{} No SAML 2 Assertion validator could be resolved", (Object)this.getLogPrefix());
        return null;
    }

    @Nonnull
    protected ValidationContext buildValidationContext(@Nonnull ProfileRequestContext profileContext, @Nonnull Assertion assertion) throws AssertionValidationException {
        ValidationContext validationContext = this.getValidationContextBuilder().apply(new AssertionValidationInput(profileContext, this.getHttpServletRequest(), assertion));
        if (validationContext == null) {
            this.log.warn("{} ValidationContext produced was null", (Object)this.getLogPrefix());
            throw new AssertionValidationException("Assertion ValidationContext was null");
        }
        return validationContext;
    }

    public static class AssertionValidationInput {
        private ProfileRequestContext profileContext;
        private HttpServletRequest httpServletRequest;
        private Assertion assertion;

        public AssertionValidationInput(@Nonnull ProfileRequestContext context, @Nonnull HttpServletRequest request, @Nonnull Assertion samlAssertion) {
            this.profileContext = Constraint.isNotNull(context, "ProfileRequestContext may not be null");
            this.httpServletRequest = Constraint.isNotNull(request, "HttpServletRequest may not be null");
            this.assertion = Constraint.isNotNull(samlAssertion, "Assertion may not be null");
        }

        @Nonnull
        public ProfileRequestContext getProfileRequestContext() {
            return this.profileContext;
        }

        @Nonnull
        public HttpServletRequest getHttpServletRequest() {
            return this.httpServletRequest;
        }

        @Nonnull
        public Assertion getAssertion() {
            return this.assertion;
        }
    }

    public class DefaultAssertionResolver
    implements Function<ProfileRequestContext, List<Assertion>> {
        @Override
        public List<Assertion> apply(@Nonnull ProfileRequestContext profileContext) {
            SAMLObject message = (SAMLObject)profileContext.getInboundMessageContext().getMessage();
            if (message instanceof Response) {
                return ((Response)message).getAssertions();
            }
            return null;
        }
    }
}

