/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessorRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedType;

public final class KeyAgreementSupport {
    public static final Set<String> KEY_ALGORITHMS = Set.of("EC", "DH");

    private KeyAgreementSupport() {
    }

    @Nullable
    public static KeyAgreementProcessorRegistry getGlobalProcessorRegistry() {
        return ConfigurationService.get(KeyAgreementProcessorRegistry.class);
    }

    @Nonnull
    public static KeyAgreementProcessor getProcessor(@Nonnull String algorithm) throws KeyAgreementException {
        KeyAgreementProcessorRegistry registry = KeyAgreementSupport.getGlobalProcessorRegistry();
        if (registry == null) {
            throw new KeyAgreementException("Global KeyAgreementProcessorRegistry not configured");
        }
        KeyAgreementProcessor processor = registry.getProcessor(algorithm);
        if (processor == null) {
            throw new KeyAgreementException("No KeyAgreementProcessor registered for specified algorithm: " + algorithm);
        }
        return processor;
    }

    @Nullable
    public static Integer getExplicitKeySize(@Nonnull AgreementMethod agreementMethod) {
        if (agreementMethod.getParent() == null || agreementMethod.getParent().getParent() == null || !EncryptedType.class.isInstance(agreementMethod.getParent().getParent())) {
            return null;
        }
        EncryptedType et = (EncryptedType)EncryptedType.class.cast(agreementMethod.getParent().getParent());
        if (et.getEncryptionMethod() == null || et.getEncryptionMethod().getKeySize() == null) {
            return null;
        }
        return et.getEncryptionMethod().getKeySize().getValue();
    }

    public static void validateKeyAlgorithmAndSize(@Nonnull String algorithmURI, @Nullable Integer specifiedKeyLength) throws KeyAgreementException {
        Integer algoKeyLength = AlgorithmSupport.getKeyLength(algorithmURI);
        if (algoKeyLength == null && specifiedKeyLength == null) {
            throw new KeyAgreementException("Key length was not specified and key algorithm does not imply a length: " + algorithmURI);
        }
        if (algoKeyLength != null && specifiedKeyLength != null && !algoKeyLength.equals(specifiedKeyLength)) {
            throw new KeyAgreementException(String.format("Algorithm URI '%s' key length (%d) does not match specified (%d)", algorithmURI, algoKeyLength, specifiedKeyLength));
        }
    }

    public static boolean supportsKeyAgreement(@Nullable Credential credential) {
        if (credential == null) {
            return false;
        }
        return credential.getPublicKey() != null && KEY_ALGORITHMS.contains(credential.getPublicKey().getAlgorithm());
    }
}

