/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import com.google.common.base.Predicates;
import java.security.Key;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Resolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.AlgorithmPolicyParameters;
import org.opensaml.xmlsec.impl.ExcludedAlgorithmsPredicate;
import org.opensaml.xmlsec.impl.IncludedAlgorithmsPredicate;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityParametersResolver<ProductType>
implements Resolver<ProductType, CriteriaSet> {
    private Logger log = LoggerFactory.getLogger(AbstractSecurityParametersResolver.class);

    @Nullable
    protected KeyInfoGenerator lookupKeyInfoGenerator(@Nonnull Credential credential, @Nullable NamedKeyInfoGeneratorManager manager, @Nullable String keyInfoProfileName) {
        Constraint.isNotNull(credential, "Credential may not be null");
        if (manager == null) {
            this.log.trace("NamedKeyInfoGeneratorManger was null, can not resolve");
            return null;
        }
        if (this.log.isTraceEnabled()) {
            Key key = CredentialSupport.extractSigningKey(credential);
            if (key == null) {
                key = CredentialSupport.extractEncryptionKey(credential);
            }
            this.log.trace("Attempting to resolve KeyInfoGenerator for credential with key algo '{}' of impl: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"), (Object)credential.getClass().getName());
        }
        return KeyInfoSupport.getKeyInfoGenerator(credential, manager, keyInfoProfileName);
    }

    protected void resolveAndPopulateIncludesExcludes(@Nonnull AlgorithmPolicyParameters params, @Nonnull CriteriaSet criteria, @Nonnull @NonnullElements @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        Collection<String> includes = this.resolveEffectiveIncludes(criteria, configs);
        this.log.trace("Resolved effective includes: {}", (Object)includes);
        Collection<String> excludes = this.resolveEffectiveExcludes(criteria, configs);
        this.log.trace("Resolved effective excludes: {}", (Object)excludes);
        if (includes.isEmpty() && excludes.isEmpty()) {
            this.log.trace("Both empty, nothing to populate");
            return;
        }
        if (includes.isEmpty()) {
            this.log.trace("Includes empty, populating excludes");
            params.setExcludedAlgorithms(excludes);
            return;
        }
        if (excludes.isEmpty()) {
            this.log.trace("Excludes empty, populating includes");
            params.setIncludedAlgorithms(includes);
            return;
        }
        AlgorithmPolicyConfiguration.Precedence precedence = this.resolveIncludeExcludePrecedence(criteria, configs);
        this.log.trace("Resolved effective precedence: {}", (Object)precedence);
        switch (precedence) {
            case INCLUDE: {
                this.log.trace("Based on precedence, populating includes");
                params.setIncludedAlgorithms(includes);
                break;
            }
            case EXCLUDE: {
                this.log.trace("Based on precedence, populating excludes");
                params.setExcludedAlgorithms(excludes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Include/Exclude Precedence value is unknown: " + precedence);
            }
        }
    }

    @Nonnull
    protected Predicate<String> resolveIncludeExcludePredicate(@Nonnull CriteriaSet criteria, @Nonnull @NonnullElements @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        Collection<String> includes = this.resolveEffectiveIncludes(criteria, configs);
        this.log.trace("Resolved effective includes: {}", (Object)includes);
        Collection<String> excludes = this.resolveEffectiveExcludes(criteria, configs);
        this.log.trace("Resolved effective excludes: {}", (Object)excludes);
        if (includes.isEmpty() && excludes.isEmpty()) {
            this.log.trace("Both empty, returning alwaysTrue predicate");
            return Predicates.alwaysTrue();
        }
        if (includes.isEmpty()) {
            this.log.trace("Includes empty, returning ExcludedAlgorithmsPredicate");
            return new ExcludedAlgorithmsPredicate(excludes);
        }
        if (excludes.isEmpty()) {
            this.log.trace("Excludes empty, returning IncludedAlgorithmsPredicate");
            return new IncludedAlgorithmsPredicate(includes);
        }
        AlgorithmPolicyConfiguration.Precedence precedence = this.resolveIncludeExcludePrecedence(criteria, configs);
        this.log.trace("Resolved effective precedence: {}", (Object)precedence);
        switch (precedence) {
            case INCLUDE: {
                this.log.trace("Based on precedence, returning IncludedAlgorithmsPredicate");
                return new IncludedAlgorithmsPredicate(includes);
            }
            case EXCLUDE: {
                this.log.trace("Based on precedence, returning ExcludedAlgorithmsPredicate");
                return new ExcludedAlgorithmsPredicate(excludes);
            }
        }
        throw new IllegalArgumentException("Include/Exclude Precedence value is unknown: " + precedence);
    }

    @Nonnull
    protected Collection<String> resolveEffectiveExcludes(@Nonnull CriteriaSet criteria, @Nonnull @NonnullElements @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        LazySet<String> accumulator = new LazySet<String>();
        for (AlgorithmPolicyConfiguration algorithmPolicyConfiguration : configs) {
            accumulator.addAll(algorithmPolicyConfiguration.getExcludedAlgorithms());
            if (algorithmPolicyConfiguration.isExcludeMerge()) continue;
            break;
        }
        return accumulator;
    }

    @Nonnull
    protected Collection<String> resolveEffectiveIncludes(@Nonnull CriteriaSet criteria, @Nonnull @NonnullElements @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        LazySet<String> accumulator = new LazySet<String>();
        for (AlgorithmPolicyConfiguration algorithmPolicyConfiguration : configs) {
            accumulator.addAll(algorithmPolicyConfiguration.getIncludedAlgorithms());
            if (algorithmPolicyConfiguration.isIncludeMerge()) continue;
            break;
        }
        return accumulator;
    }

    @Nonnull
    protected AlgorithmPolicyConfiguration.Precedence resolveIncludeExcludePrecedence(@Nonnull CriteriaSet criteria, @Nonnull @NonnullElements @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        return configs.get(0).getIncludeExcludePrecedence();
    }
}

