/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;

public class BasicAlgorithmPolicyConfiguration
implements AlgorithmPolicyConfiguration {
    public static final AlgorithmPolicyConfiguration.Precedence DEFAULT_PRECEDENCE = AlgorithmPolicyConfiguration.Precedence.INCLUDE;
    private Collection<String> includes = Collections.emptySet();
    private boolean includeMerge = false;
    private Collection<String> excludes = Collections.emptySet();
    private boolean excludeMerge = true;
    private AlgorithmPolicyConfiguration.Precedence precedence = DEFAULT_PRECEDENCE;

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<String> getIncludedAlgorithms() {
        return this.includes;
    }

    public void setIncludedAlgorithms(@Nullable Collection<String> uris) {
        if (uris == null) {
            this.includes = Collections.emptySet();
            return;
        }
        this.includes = Set.copyOf(StringSupport.normalizeStringCollection(uris));
    }

    @Override
    public boolean isIncludeMerge() {
        return this.includeMerge;
    }

    public void setIncludeMerge(boolean flag) {
        this.includeMerge = flag;
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<String> getExcludedAlgorithms() {
        return this.excludes;
    }

    public void setExcludedAlgorithms(@Nullable Collection<String> uris) {
        if (uris == null) {
            this.excludes = Collections.emptySet();
            return;
        }
        this.excludes = Set.copyOf(StringSupport.normalizeStringCollection(uris));
    }

    @Override
    public boolean isExcludeMerge() {
        return this.excludeMerge;
    }

    public void setExcludeMerge(boolean flag) {
        this.excludeMerge = flag;
    }

    @Override
    @Nonnull
    public AlgorithmPolicyConfiguration.Precedence getIncludeExcludePrecedence() {
        return this.precedence;
    }

    public void setIncludeExcludePrecedence(@Nonnull AlgorithmPolicyConfiguration.Precedence value) {
        this.precedence = Constraint.isNotNull(value, "Precedence may not be null");
    }
}

