/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.HashMap;

class Mnemonic {
    static final int CASE_SENSITIVE = 1;
    static final int CASE_UPPER = 2;
    static final int CASE_LOWER = 3;
    private final HashMap<String, Integer> strings;
    private final HashMap<Integer, String> values;
    private final String description;
    private final int wordcase;
    private String prefix;
    private int max;
    private boolean numericok;

    public Mnemonic(String description, int wordcase) {
        this.description = description;
        this.wordcase = wordcase;
        this.strings = new HashMap();
        this.values = new HashMap();
        this.max = Integer.MAX_VALUE;
    }

    public void setMaximum(int max) {
        this.max = max;
    }

    public void setPrefix(String prefix) {
        this.prefix = this.sanitize(prefix);
    }

    public void setNumericAllowed(boolean numeric) {
        this.numericok = numeric;
    }

    public void check(int val2) {
        if (val2 < 0 || val2 > this.max) {
            throw new IllegalArgumentException(this.description + " " + val2 + " is out of range");
        }
    }

    private String sanitize(String str) {
        if (this.wordcase == 2) {
            return str.toUpperCase();
        }
        if (this.wordcase == 3) {
            return str.toLowerCase();
        }
        return str;
    }

    private int parseNumeric(String s) {
        try {
            int val2 = Integer.parseInt(s);
            if (val2 >= 0 && val2 <= this.max) {
                return val2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public void add(int val2, String str) {
        this.check(val2);
        str = this.sanitize(str);
        this.strings.put(str, val2);
        this.values.put(val2, str);
    }

    public void remove(int val2) {
        this.values.remove(val2);
        this.strings.entrySet().removeIf(entry -> (Integer)entry.getValue() == val2);
    }

    public void addAlias(int val2, String str) {
        this.check(val2);
        str = this.sanitize(str);
        this.strings.put(str, val2);
    }

    public void removeAlias(String str) {
        str = this.sanitize(str);
        this.strings.remove(str);
    }

    public void addAll(Mnemonic source) {
        if (this.wordcase != source.wordcase) {
            throw new IllegalArgumentException(source.description + ": wordcases do not match");
        }
        this.strings.putAll(source.strings);
        this.values.putAll(source.values);
    }

    public String getText(int val2) {
        this.check(val2);
        String str = this.values.get(val2);
        if (str != null) {
            return str;
        }
        str = Integer.toString(val2);
        if (this.prefix != null) {
            return this.prefix + str;
        }
        return str;
    }

    public int getValue(String str) {
        int val2;
        Integer value = this.strings.get(str = this.sanitize(str));
        if (value != null) {
            return value;
        }
        if (this.prefix != null && str.startsWith(this.prefix) && (val2 = this.parseNumeric(str.substring(this.prefix.length()))) >= 0) {
            return val2;
        }
        if (this.numericok) {
            return this.parseNumeric(str);
        }
        return -1;
    }
}

