/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.HashMap;
import java.util.function.Supplier;
import org.xbill.DNS.A6Record;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.AFSDBRecord;
import org.xbill.DNS.APLRecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CAARecord;
import org.xbill.DNS.CDNSKEYRecord;
import org.xbill.DNS.CDSRecord;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DHCIDRecord;
import org.xbill.DNS.DLVRecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DSRecord;
import org.xbill.DNS.GPOSRecord;
import org.xbill.DNS.HINFORecord;
import org.xbill.DNS.HIPRecord;
import org.xbill.DNS.HTTPSRecord;
import org.xbill.DNS.IPSECKEYRecord;
import org.xbill.DNS.ISDNRecord;
import org.xbill.DNS.InvalidTypeException;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.KXRecord;
import org.xbill.DNS.LOCRecord;
import org.xbill.DNS.MBRecord;
import org.xbill.DNS.MDRecord;
import org.xbill.DNS.MFRecord;
import org.xbill.DNS.MGRecord;
import org.xbill.DNS.MINFORecord;
import org.xbill.DNS.MRRecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.NSAPRecord;
import org.xbill.DNS.NSAP_PTRRecord;
import org.xbill.DNS.NSEC3PARAMRecord;
import org.xbill.DNS.NSEC3Record;
import org.xbill.DNS.NSECRecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.NULLRecord;
import org.xbill.DNS.NXTRecord;
import org.xbill.DNS.OPENPGPKEYRecord;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.PXRecord;
import org.xbill.DNS.RPRecord;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RTRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.SMIMEARecord;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SPFRecord;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.SSHFPRecord;
import org.xbill.DNS.SVCBRecord;
import org.xbill.DNS.TKEYRecord;
import org.xbill.DNS.TLSARecord;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.URIRecord;
import org.xbill.DNS.Utils;
import org.xbill.DNS.WKSRecord;
import org.xbill.DNS.X25Record;
import org.xbill.DNS.ZoneMDRecord;

public final class Type {
    public static final int A = 1;
    public static final int NS = 2;
    public static final int MD = 3;
    public static final int MF = 4;
    public static final int CNAME = 5;
    public static final int SOA = 6;
    public static final int MB = 7;
    public static final int MG = 8;
    public static final int MR = 9;
    public static final int NULL = 10;
    public static final int WKS = 11;
    public static final int PTR = 12;
    public static final int HINFO = 13;
    public static final int MINFO = 14;
    public static final int MX = 15;
    public static final int TXT = 16;
    public static final int RP = 17;
    public static final int AFSDB = 18;
    public static final int X25 = 19;
    public static final int ISDN = 20;
    public static final int RT = 21;
    public static final int NSAP = 22;
    public static final int NSAP_PTR = 23;
    public static final int SIG = 24;
    public static final int KEY = 25;
    public static final int PX = 26;
    public static final int GPOS = 27;
    public static final int AAAA = 28;
    public static final int LOC = 29;
    public static final int NXT = 30;
    public static final int EID = 31;
    public static final int NIMLOC = 32;
    public static final int SRV = 33;
    public static final int ATMA = 34;
    public static final int NAPTR = 35;
    public static final int KX = 36;
    public static final int CERT = 37;
    public static final int A6 = 38;
    public static final int DNAME = 39;
    public static final int SINK = 40;
    public static final int OPT = 41;
    public static final int APL = 42;
    public static final int DS = 43;
    public static final int SSHFP = 44;
    public static final int IPSECKEY = 45;
    public static final int RRSIG = 46;
    public static final int NSEC = 47;
    public static final int DNSKEY = 48;
    public static final int DHCID = 49;
    public static final int NSEC3 = 50;
    public static final int NSEC3PARAM = 51;
    public static final int TLSA = 52;
    public static final int SMIMEA = 53;
    public static final int HIP = 55;
    public static final int NINFO = 56;
    public static final int RKEY = 57;
    public static final int TALINK = 58;
    public static final int CDS = 59;
    public static final int CDNSKEY = 60;
    public static final int OPENPGPKEY = 61;
    public static final int CSYNC = 62;
    public static final int ZONEMD = 63;
    public static final int SVCB = 64;
    public static final int HTTPS = 65;
    public static final int SPF = 99;
    public static final int UINFO = 100;
    public static final int UID = 101;
    public static final int GID = 102;
    public static final int UNSPEC = 103;
    public static final int NID = 104;
    public static final int L32 = 105;
    public static final int L64 = 106;
    public static final int LP = 107;
    public static final int EUI48 = 108;
    public static final int EUI64 = 109;
    public static final int TKEY = 249;
    public static final int TSIG = 250;
    public static final int IXFR = 251;
    public static final int AXFR = 252;
    public static final int MAILB = 253;
    public static final int MAILA = 254;
    public static final int ANY = 255;
    public static final int URI = 256;
    public static final int CAA = 257;
    public static final int AVC = 258;
    public static final int DOA = 259;
    public static final int AMTRELAY = 260;
    public static final int TA = 32768;
    public static final int DLV = 32769;
    private static final TypeMnemonic types = new TypeMnemonic();

    private Type() {
    }

    public static void check(int val2) {
        if (!Utils.isUInt16(val2)) {
            throw new InvalidTypeException(val2);
        }
    }

    public static void register(int val2, String str, Supplier<Record> factory) {
        types.replace(val2, str, factory);
    }

    public static String string(int val2) {
        return types.getText(val2);
    }

    public static int value(String s, boolean numberok) {
        int val2 = types.getValue(s);
        if (val2 == -1 && numberok) {
            val2 = types.getValue("TYPE" + s);
        }
        return val2;
    }

    public static int value(String s) {
        return Type.value(s, false);
    }

    static Supplier<Record> getFactory(int val2) {
        return types.getFactory(val2);
    }

    public static boolean isRR(int type) {
        switch (type) {
            case 41: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return false;
            }
        }
        return true;
    }

    static {
        types.add(1, "A", ARecord::new);
        types.add(2, "NS", NSRecord::new);
        types.add(3, "MD", MDRecord::new);
        types.add(4, "MF", MFRecord::new);
        types.add(5, "CNAME", CNAMERecord::new);
        types.add(6, "SOA", SOARecord::new);
        types.add(7, "MB", MBRecord::new);
        types.add(8, "MG", MGRecord::new);
        types.add(9, "MR", MRRecord::new);
        types.add(10, "NULL", NULLRecord::new);
        types.add(11, "WKS", WKSRecord::new);
        types.add(12, "PTR", PTRRecord::new);
        types.add(13, "HINFO", HINFORecord::new);
        types.add(14, "MINFO", MINFORecord::new);
        types.add(15, "MX", MXRecord::new);
        types.add(16, "TXT", TXTRecord::new);
        types.add(17, "RP", RPRecord::new);
        types.add(18, "AFSDB", AFSDBRecord::new);
        types.add(19, "X25", X25Record::new);
        types.add(20, "ISDN", ISDNRecord::new);
        types.add(21, "RT", RTRecord::new);
        types.add(22, "NSAP", NSAPRecord::new);
        types.add(23, "NSAP-PTR", NSAP_PTRRecord::new);
        types.add(24, "SIG", SIGRecord::new);
        types.add(25, "KEY", KEYRecord::new);
        types.add(26, "PX", PXRecord::new);
        types.add(27, "GPOS", GPOSRecord::new);
        types.add(28, "AAAA", AAAARecord::new);
        types.add(29, "LOC", LOCRecord::new);
        types.add(30, "NXT", NXTRecord::new);
        types.add(31, "EID");
        types.add(32, "NIMLOC");
        types.add(33, "SRV", SRVRecord::new);
        types.add(34, "ATMA");
        types.add(35, "NAPTR", NAPTRRecord::new);
        types.add(36, "KX", KXRecord::new);
        types.add(37, "CERT", CERTRecord::new);
        types.add(38, "A6", A6Record::new);
        types.add(39, "DNAME", DNAMERecord::new);
        types.add(40, "SINK");
        types.add(41, "OPT", OPTRecord::new);
        types.add(42, "APL", APLRecord::new);
        types.add(43, "DS", DSRecord::new);
        types.add(44, "SSHFP", SSHFPRecord::new);
        types.add(45, "IPSECKEY", IPSECKEYRecord::new);
        types.add(46, "RRSIG", RRSIGRecord::new);
        types.add(47, "NSEC", NSECRecord::new);
        types.add(48, "DNSKEY", DNSKEYRecord::new);
        types.add(49, "DHCID", DHCIDRecord::new);
        types.add(50, "NSEC3", NSEC3Record::new);
        types.add(51, "NSEC3PARAM", NSEC3PARAMRecord::new);
        types.add(52, "TLSA", TLSARecord::new);
        types.add(53, "SMIMEA", SMIMEARecord::new);
        types.add(55, "HIP", HIPRecord::new);
        types.add(56, "NINFO");
        types.add(57, "RKEY");
        types.add(58, "TALINK");
        types.add(59, "CDS", CDSRecord::new);
        types.add(60, "CDNSKEY", CDNSKEYRecord::new);
        types.add(61, "OPENPGPKEY", OPENPGPKEYRecord::new);
        types.add(62, "CSYNC");
        types.add(63, "ZONEMD", ZoneMDRecord::new);
        types.add(64, "SVCB", SVCBRecord::new);
        types.add(65, "HTTPS", HTTPSRecord::new);
        types.add(99, "SPF", SPFRecord::new);
        types.add(100, "UINFO");
        types.add(101, "UID");
        types.add(102, "GID");
        types.add(103, "UNSPEC");
        types.add(104, "NID");
        types.add(105, "L32");
        types.add(106, "L64");
        types.add(107, "LP");
        types.add(108, "EUI48");
        types.add(109, "EUI64");
        types.add(249, "TKEY", TKEYRecord::new);
        types.add(250, "TSIG", TSIGRecord::new);
        types.add(251, "IXFR");
        types.add(252, "AXFR");
        types.add(253, "MAILB");
        types.add(254, "MAILA");
        types.add(255, "ANY");
        types.add(256, "URI", URIRecord::new);
        types.add(257, "CAA", CAARecord::new);
        types.add(258, "AVC");
        types.add(259, "DOA");
        types.add(260, "AMTRELAY");
        types.add(32768, "TA");
        types.add(32769, "DLV", DLVRecord::new);
    }

    private static class TypeMnemonic
    extends Mnemonic {
        private final HashMap<Integer, Supplier<Record>> factories;

        public TypeMnemonic() {
            super("Type", 2);
            this.setPrefix("TYPE");
            this.setMaximum(65535);
            this.factories = new HashMap();
        }

        public void add(int val2, String str, Supplier<Record> factory) {
            super.add(val2, str);
            this.factories.put(val2, factory);
        }

        public void replace(int val2, String str, Supplier<Record> factory) {
            int oldVal = this.getValue(str);
            if (oldVal != -1) {
                if (oldVal != val2) {
                    throw new IllegalArgumentException("mnemnonic \"" + str + "\" already used by type " + oldVal);
                }
                this.remove(val2);
                this.factories.remove(val2);
            }
            this.add(val2, str, factory);
        }

        @Override
        public void check(int val2) {
            Type.check(val2);
        }

        public Supplier<Record> getFactory(int val2) {
            this.check(val2);
            return this.factories.get(val2);
        }
    }
}

