/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.statistics.model;

import java.util.Date;
import network.oxalis.ng.api.model.AccessPointIdentifier;
import network.oxalis.ng.api.model.Direction;
import network.oxalis.ng.statistics.api.ChannelId;
import network.oxalis.ng.statistics.api.RawStatistics;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;

abstract class AbstractStatistics
implements RawStatistics {
    AccessPointIdentifier accessPointIdentifier;
    Date date;
    Direction direction;
    DocumentTypeIdentifier peppolDocumentTypeId;
    ChannelId channelId;
    ProcessIdentifier processIdentifier;

    AbstractStatistics(AbstractBuilder abstractBuilder) {
        this.processIdentifier = abstractBuilder.peppolProcessTypeId;
        this.peppolDocumentTypeId = abstractBuilder.peppolDocumentTypeId;
        this.accessPointIdentifier = abstractBuilder.accessPointIdentifier;
        this.date = abstractBuilder.date;
        this.direction = abstractBuilder.direction;
        this.channelId = abstractBuilder.channelId;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public AccessPointIdentifier getAccessPointIdentifier() {
        return this.accessPointIdentifier;
    }

    @Override
    public DocumentTypeIdentifier getDocumentTypeIdentifier() {
        return this.peppolDocumentTypeId;
    }

    @Override
    public ChannelId getChannelId() {
        return this.channelId;
    }

    @Override
    public ProcessIdentifier getProcessIdentifier() {
        return this.processIdentifier;
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder, B> {
        AccessPointIdentifier accessPointIdentifier;
        Date date = new Date();
        Direction direction;
        DocumentTypeIdentifier peppolDocumentTypeId;
        ProcessIdentifier peppolProcessTypeId;
        ChannelId channelId;

        protected AbstractBuilder() {
        }

        public T date(Date dt) {
            this.date = dt;
            return this.getThis();
        }

        public T accessPointIdentifier(AccessPointIdentifier accessPointIdentifier) {
            this.accessPointIdentifier = accessPointIdentifier;
            return this.getThis();
        }

        public T direction(Direction direction) {
            this.direction = direction;
            return this.getThis();
        }

        public T outbound() {
            this.direction = Direction.OUT;
            return this.getThis();
        }

        public T inbound() {
            this.direction = Direction.IN;
            return this.getThis();
        }

        public T documentType(DocumentTypeIdentifier peppolDocumentTypeId) {
            this.peppolDocumentTypeId = peppolDocumentTypeId;
            return this.getThis();
        }

        public T profile(ProcessIdentifier processIdentifier) {
            this.peppolProcessTypeId = processIdentifier;
            return this.getThis();
        }

        public T channel(ChannelId channelId) {
            this.channelId = channelId;
            return this.getThis();
        }

        protected void checkRequiredFields() {
            if (this.direction == null) {
                throw new IllegalStateException("Must specify the direction of the message");
            }
            if (this.accessPointIdentifier == null) {
                throw new IllegalStateException("Identity of access point required");
            }
            if (this.peppolDocumentTypeId == null) {
                throw new IllegalStateException("Document type required");
            }
            if (this.peppolProcessTypeId == null) {
                throw new IllegalStateException("Process id/profile id required");
            }
            if (this.date == null) {
                throw new IllegalStateException("Date (period) required");
            }
        }

        public abstract B build();

        protected abstract T getThis();
    }
}

