/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.statistics.security;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsKeyTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsKeyTool.class);
    public static final String ASYMMETRIC_KEY_ALGORITHM = "RSA";
    public static final String OXALIS_STATISTICS_PUBLIC_KEY = "oxalis-statistics-public.key";
    public static final int MAX_LENGTH_OF_ENCODED_KEY = 4096;

    public PublicKey loadPublicKeyFromClassPath() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(OXALIS_STATISTICS_PUBLIC_KEY);
        if (inputStream == null) {
            throw new IllegalStateException("Unable to locate file oxalis-statistics-public.key");
        }
        try {
            byte[] bytes = this.loadBytesFrom(inputStream);
            log.info("Loaded public key with " + bytes.length + " bytes");
            PublicKey publicKey = this.publicKeyFromBytes(bytes);
            return publicKey;
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("Invalid public key encoded in oxalis-statistics-public.key", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close input stream for oxalis-statistics-public.key", e);
            }
        }
    }

    public PublicKey loadPublicKey(File file) {
        try {
            byte[] encodedPublicKey = this.loadBytesFromFile(file);
            return this.publicKeyFromBytes(encodedPublicKey);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("Unable to create key from encoded specification in " + file.getAbsolutePath() + "; " + e.getMessage(), e);
        }
    }

    File getPublicKeyFile() {
        return new File(this.getResourceDirectory(), OXALIS_STATISTICS_PUBLIC_KEY);
    }

    File getResourceDirectory() {
        String tempDirName = System.getProperty("java.io.tmpdir");
        return new File(tempDirName);
    }

    private PublicKey publicKeyFromBytes(byte[] encodedPublicKey) throws InvalidKeySpecException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(encodedPublicKey);
        KeyFactory keyFactory = this.createKeyFactory();
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    private byte[] loadBytesFromFile(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = this.loadBytesFrom(fileInputStream);
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Unable to open file " + file.getAbsolutePath());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to close file " + file.getAbsolutePath(), e);
                }
            }
        }
    }

    private byte[] loadBytesFrom(InputStream inputStream) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        try {
            int nRead;
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return buffer.toByteArray();
    }

    private KeyFactory createKeyFactory() {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ASYMMETRIC_KEY_ALGORITHM);
            return keyFactory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create key factory with algorithm RSA; " + e.getMessage(), e);
        }
    }
}

