/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.rule;

import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import network.oxalis.commons.certvalidator.api.CertificateBucket;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.FailedValidationException;
import network.oxalis.commons.certvalidator.api.Property;
import network.oxalis.commons.certvalidator.api.Report;
import network.oxalis.commons.certvalidator.rule.AbstractRule;
import network.oxalis.commons.certvalidator.util.SimpleProperty;
import network.oxalis.pkix.ocsp.CertificateResult;
import network.oxalis.pkix.ocsp.OcspClient;
import network.oxalis.pkix.ocsp.OcspException;
import network.oxalis.pkix.ocsp.OcspServerException;

public class OCSPRule
extends AbstractRule {
    public static final Property<CertificateResult> RESULT = SimpleProperty.create();
    protected OcspClient ocspClient;

    public OCSPRule(CertificateBucket intermediateCertificates) {
        this.ocspClient = OcspClient.builder().set(OcspClient.INTERMEDIATES, intermediateCertificates.asList()).build();
    }

    public OCSPRule(OcspClient ocspClient) {
        this.ocspClient = ocspClient;
    }

    @Override
    public Report validate(X509Certificate certificate, Report report) throws CertificateValidationException {
        try {
            report.set(RESULT, this.ocspClient.verify(certificate));
            return report;
        }
        catch (OcspServerException e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
        catch (OcspException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new CertificateValidationException(e.getMessage(), e);
            }
            throw new FailedValidationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }
}

