/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.outbound;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.security.Security;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import network.oxalis.ng.api.outbound.MessageSender;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.as4.config.As4Conf;
import network.oxalis.ng.as4.outbound.As4MessageSender;
import network.oxalis.ng.as4.outbound.As4MessageSenderFacade;
import network.oxalis.ng.as4.outbound.MessagingProvider;
import network.oxalis.ng.as4.outbound.TransmissionResponseConverter;
import network.oxalis.ng.as4.util.CompressionUtil;
import network.oxalis.ng.as4.util.PeppolConfiguration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class As4OutboundModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(As4OutboundModule.class);

    @Override
    protected void configure() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        this.bind(Key.get(MessageSender.class, (Annotation)Names.named("oxalis-as4"))).to(As4MessageSenderFacade.class);
        this.bind(Key.get(ExecutorService.class, (Annotation)Names.named("compression-pool"))).toProvider(() -> Executors.newFixedThreadPool(5)).in(Scopes.SINGLETON);
        this.bind(CompressionUtil.class);
        this.bind(MessagingProvider.class);
        this.bind(As4MessageSender.class);
        this.bind(TransmissionResponseConverter.class);
    }

    @Provides
    @Singleton
    public PeppolConfiguration getPeppolOutboundConfiguration(Settings<As4Conf> settings) {
        String type = settings.getString(As4Conf.TYPE);
        if ("cef-connectivity".equalsIgnoreCase(type)) {
            return new PeppolConfiguration(){

                @Override
                public String getPartyIDType() {
                    return "urn:oasis:names:tc:ebcore:partyid-type:unregistered";
                }

                @Override
                public String getAgreementRef() {
                    return null;
                }
            };
        }
        return new PeppolConfiguration();
    }
}

