/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.filesystem.detector;

import java.io.File;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import lombok.Generated;
import network.oxalis.ng.api.filesystem.HomeDetector;
import network.oxalis.ng.api.util.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Sort(value=1000)
public class JndiHomeDetector
implements HomeDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JndiHomeDetector.class);
    protected static final String VARIABLE = "java:comp/env/OXALIS_HOME";

    @Override
    public File detect() {
        try {
            String value = (String)new InitialContext().lookup(VARIABLE);
            if (value == null || value.isEmpty()) {
                return null;
            }
            log.info("Using Oxalis folder specified as JNDI path '{}' with value '{}'.", (Object)VARIABLE, (Object)value);
            return new File(value);
        }
        catch (NamingException ex) {
            return null;
        }
    }
}

