/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;

public class BasicKeyAgreementCredential
extends BasicCredential
implements KeyAgreementCredential {
    @Nonnull
    private String algorithm;
    @Nonnull
    private Credential originatorCredential;
    @Nonnull
    private Credential recipientCredential;
    @Nonnull
    private KeyAgreementParameters parameters;

    public BasicKeyAgreementCredential(@Nonnull SecretKey derivedKey, @Nonnull String agreementAlgorithm, @Nonnull Credential originator, @Nonnull Credential recipient) {
        super(Constraint.isNotNull(derivedKey, "SecretKey was null"));
        this.algorithm = Constraint.isNotNull(StringSupport.trimOrNull(agreementAlgorithm), "Algorithm was null");
        this.originatorCredential = Constraint.isNotNull(originator, "Originator credential was null");
        this.recipientCredential = Constraint.isNotNull(recipient, "Recipient credential was null");
        this.parameters = new KeyAgreementParameters();
    }

    @Override
    @Nonnull
    public Class<? extends Credential> getCredentialType() {
        return KeyAgreementCredential.class;
    }

    @Override
    @Nonnull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @Nonnull
    public Credential getOriginatorCredential() {
        return this.originatorCredential;
    }

    @Override
    @Nonnull
    public Credential getRecipientCredential() {
        return this.recipientCredential;
    }

    @Override
    @Nonnull
    public KeyAgreementParameters getParameters() {
        return this.parameters;
    }
}

