/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.filesystem.detector;

import java.io.File;
import java.util.Map;
import lombok.Generated;
import network.oxalis.ng.api.filesystem.HomeDetector;
import network.oxalis.ng.api.util.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Sort(value=3000)
public class EnvironmentHomeDetector
implements HomeDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentHomeDetector.class);
    protected static final String VARIABLE = "OXALIS_HOME";
    private Map<String, String> environment;

    public EnvironmentHomeDetector(Map<String, String> environment) {
        this.environment = environment;
    }

    public EnvironmentHomeDetector() {
        this(System.getenv());
    }

    @Override
    public File detect() {
        if (!this.environment.containsKey(VARIABLE)) {
            return null;
        }
        String value = this.environment.get(VARIABLE);
        log.info("Using Oxalis folder specified as environment variable '{}' with value '{}'.", (Object)VARIABLE, (Object)value);
        return new File(value);
    }
}

