/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.mode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.opentelemetry.api.trace.Span;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.pkix.ocsp.api.OcspFetcherResponse;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.protocol.BasicHttpContext;

@Singleton
public class OxalisOcspFetcher
implements OcspFetcher {
    @Inject
    private Provider<CloseableHttpClient> httpClientProvider;
    @Inject
    @Named(value="certificate")
    private RequestConfig requestConfig;

    @Override
    public OcspFetcherResponse fetch(URI uri, byte[] content) throws IOException {
        Span span = Span.current();
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        if (span != null) {
            basicHttpContext.setAttribute(OxalisOcspFetcher.class.getName() + ".parentSpanContext", span.getSpanContext());
        }
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", "application/ocsp-request");
        httpPost.setHeader("Accept", "application/ocsp-response");
        httpPost.setEntity(new ByteArrayEntity(content, ContentType.create("application/ocsp-request")));
        httpPost.setConfig(this.requestConfig);
        return new ApacheOcspFetcherResponse(this.httpClientProvider.get().execute((ClassicHttpRequest)httpPost, basicHttpContext));
    }

    private class ApacheOcspFetcherResponse
    implements OcspFetcherResponse {
        private CloseableHttpResponse response;

        public ApacheOcspFetcherResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        @Override
        public int getStatus() {
            return this.response.getCode();
        }

        @Override
        public String getContentType() {
            return this.response.getFirstHeader("Content-Type").getValue();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.response.getEntity().getContent();
        }

        @Override
        public void close() throws IOException {
            this.response.close();
            this.response = null;
        }
    }
}

