/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache.jcache;

import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.ws.security.utils.JCacheSupport;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JCacheReplayCache
implements ReplayCache {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheReplayCache.class);
    private final Cache<String, EHCacheValue> cache;
    private final CacheManager cacheManager;
    private final String key;

    JCacheReplayCache(String key) throws WSSecurityException {
        this(key, 10000L);
    }

    JCacheReplayCache(String key, long heapEntries) throws WSSecurityException {
        this.key = Objects.requireNonNull(key);
        try {
            CachingProvider cachingProvider = Caching.getCachingProvider();
            this.cacheManager = cachingProvider.getCacheManager();
            this.cache = JCacheSupport.getOrCreate(this.cacheManager, key, String.class, EHCacheValue.class, cacheConfiguration -> cacheConfiguration.setExpiryPolicyFactory(() -> new ExpiryPolicy(){

                @Override
                public Duration getExpiryForCreation() {
                    return new Duration(TimeUnit.SECONDS, 3600L);
                }

                @Override
                public Duration getExpiryForAccess() {
                    return null;
                }

                @Override
                public Duration getExpiryForUpdate() {
                    return null;
                }
            }));
        }
        catch (Exception ex) {
            LOG.error("Error configuring JCacheReplayCache: {}", (Object)ex.getMessage());
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex, "replayCacheError");
        }
    }

    @Override
    public void add(String identifier) {
        this.add(identifier, null);
    }

    @Override
    public void add(String identifier, Instant expiry) {
        if (identifier == null || identifier.length() == 0) {
            return;
        }
        this.cache.put(identifier, new EHCacheValue(identifier, expiry));
    }

    @Override
    public boolean contains(String identifier) {
        if (this.cache == null) {
            return false;
        }
        EHCacheValue element = this.cache.get(identifier);
        return element != null;
    }

    EHCacheValue get(String identifier) {
        return this.cache.get(identifier);
    }

    @Override
    public synchronized void close() {
        if (!this.cacheManager.isClosed()) {
            this.cacheManager.destroyCache(this.key);
            this.cacheManager.close();
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }
}

