/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.SAMLMessageSecuritySupport;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRedirectDeflateEncoder
extends BaseSAML2MessageEncoder {
    @Nonnull
    @NonnullElements
    private static final Set<String> DISALLOWED_ENDPOINT_QUERY_PARAMS = Set.of("SAMLEncoding", "SAMLRequest", "SAMLResponse", "RelayState", "SigAlg", "Signature");
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectDeflateEncoder.class);

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (outboundMessage == null || !(outboundMessage instanceof SAMLObject)) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        String endpointURL = this.getEndpointURL(messageContext).toString();
        this.removeSignature((SAMLObject)outboundMessage);
        String encodedMessage = this.deflateAndBase64Encode((SAMLObject)outboundMessage);
        String redirectURL = this.buildRedirectURL(messageContext, endpointURL, encodedMessage);
        HttpServletResponse response = this.getHttpServletResponse();
        HttpServletSupport.addNoCacheHeaders(response);
        HttpServletSupport.setUTF8Encoding(response);
        try {
            response.sendRedirect(redirectURL);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", (Exception)e);
        }
    }

    protected void removeSignature(SAMLObject message) {
        SignableSAMLObject signableMessage;
        if (message instanceof SignableSAMLObject && (signableMessage = (SignableSAMLObject)message).isSigned()) {
            this.log.debug("Removing SAML protocol message signature");
            signableMessage.setSignature(null);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String deflateAndBase64Encode(SAMLObject message) throws MessageEncodingException {
        this.log.debug("Deflating and Base64 encoding SAML message");
        try {
            String messageStr = SerializeSupport.nodeToString(this.marshallMessage(message));
            try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
                String string;
                try (NoWrapAutoEndDeflaterOutputStream deflaterStream = new NoWrapAutoEndDeflaterOutputStream(bytesOut, 8);){
                    deflaterStream.write(messageStr.getBytes("UTF-8"));
                    deflaterStream.finish();
                    string = Base64Support.encode(bytesOut.toByteArray(), false);
                }
                return string;
            }
        }
        catch (IOException | EncodingException e) {
            throw new MessageEncodingException("Unable to DEFLATE and Base64 encode SAML message", e);
        }
    }

    protected String buildRedirectURL(MessageContext messageContext, String endpoint, String message) throws MessageEncodingException {
        SignatureSigningParameters signingParameters;
        this.log.debug("Building URL to redirect client to");
        URLBuilder urlBuilder = null;
        try {
            urlBuilder = new URLBuilder(endpoint);
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + endpoint + " is not a valid URL", (Exception)e);
        }
        List<Pair<String, String>> queryParams = urlBuilder.getQueryParams();
        this.removeDisallowedQueryParams(queryParams);
        ArrayList<Pair<String, String>> originalParams = new ArrayList<Pair<String, String>>(queryParams);
        queryParams.clear();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (outboundMessage instanceof RequestAbstractType) {
            queryParams.add(new Pair<String, String>("SAMLRequest", message));
        } else if (outboundMessage instanceof StatusResponseType) {
            queryParams.add(new Pair<String, String>("SAMLResponse", message));
        } else {
            throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
        }
        String relayState = SAMLBindingSupport.getRelayState(messageContext);
        if (SAMLBindingSupport.checkRelayState(relayState)) {
            queryParams.add(new Pair<String, String>("RelayState", relayState));
        }
        if ((signingParameters = SAMLMessageSecuritySupport.getContextSigningParameters(messageContext)) != null && signingParameters.getSigningCredential() != null) {
            String sigAlgURI = this.getSignatureAlgorithmURI(signingParameters);
            Pair<String, String> sigAlg = new Pair<String, String>("SigAlg", sigAlgURI);
            queryParams.add(sigAlg);
            String sigMaterial = urlBuilder.buildQueryString();
            queryParams.add(new Pair<String, String>("Signature", this.generateSignature(signingParameters.getSigningCredential(), sigAlgURI, sigMaterial)));
            if (!originalParams.isEmpty()) {
                for (Pair<String, String> param : Lists.reverse(originalParams)) {
                    queryParams.add(0, param);
                }
            }
        } else {
            this.log.debug("No signing credential was supplied, skipping HTTP-Redirect DEFLATE signing");
            queryParams.addAll(originalParams);
        }
        return urlBuilder.buildURL();
    }

    protected void removeDisallowedQueryParams(@Nonnull List<Pair<String, String>> queryParams) {
        Iterator<Pair<String, String>> iter = queryParams.iterator();
        while (iter.hasNext()) {
            String paramName = StringSupport.trimOrNull(iter.next().getFirst());
            if (!DISALLOWED_ENDPOINT_QUERY_PARAMS.contains(paramName)) continue;
            this.log.debug("Removing disallowed query param '{}' from endpoint URL", (Object)paramName);
            iter.remove();
        }
    }

    protected String getSignatureAlgorithmURI(SignatureSigningParameters signingParameters) throws MessageEncodingException {
        if (signingParameters.getSignatureAlgorithm() != null) {
            return signingParameters.getSignatureAlgorithm();
        }
        throw new MessageEncodingException("The signing algorithm URI could not be determined");
    }

    protected String generateSignature(Credential signingCredential, String algorithmURI, String queryString) throws MessageEncodingException {
        this.log.debug(String.format("Generating signature with key type '%s', algorithm URI '%s' over query string '%s'", CredentialSupport.extractSigningKey(signingCredential).getAlgorithm(), algorithmURI, queryString));
        String b64Signature = null;
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI(signingCredential, algorithmURI, queryString.getBytes("UTF-8"));
            b64Signature = Base64Support.encode(rawSignature, false);
            this.log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (SecurityException e) {
            this.log.error("Error during URL signing process: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to sign URL query string", (Exception)e);
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (EncodingException e) {
            this.log.error("Error during URL signing process: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to base64 encode signature of URL query string", (Exception)e);
        }
        return b64Signature;
    }

    private class NoWrapAutoEndDeflaterOutputStream
    extends DeflaterOutputStream {
        public NoWrapAutoEndDeflaterOutputStream(OutputStream os, int level) {
            super(os, new Deflater(level, true));
        }

        @Override
        public void close() throws IOException {
            if (this.def != null) {
                this.def.end();
            }
            super.close();
        }
    }
}

