/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class IncludedAlgorithmsPredicate
implements Predicate<String> {
    @Nonnull
    @NonnullElements
    private Collection<String> includes;

    public IncludedAlgorithmsPredicate(@Nonnull Collection<String> algorithms) {
        this.includes = Set.copyOf(Constraint.isNotNull(algorithms, "Inclusions may not be null"));
    }

    @Override
    public boolean test(@Nullable String input) {
        if (input == null) {
            throw new IllegalArgumentException("Algorithm URI to evaluate may not be null");
        }
        return this.includes.isEmpty() || this.includes.contains(input);
    }
}

