/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Message;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Type;

public class ExtendedResolver
implements Resolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtendedResolver.class);
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_RESOLVER_TIMEOUT = Duration.ofSeconds(5L);
    private final List<ResolverEntry> resolvers = new CopyOnWriteArrayList<ResolverEntry>();
    private final AtomicInteger lbStart = new AtomicInteger();
    private boolean loadBalance;
    private int retries = 3;
    private Duration timeout = DEFAULT_TIMEOUT;

    public ExtendedResolver() {
        List<InetSocketAddress> servers = ResolverConfig.getCurrentConfig().servers();
        this.resolvers.addAll(servers.stream().map(server -> {
            SimpleResolver r = new SimpleResolver((InetSocketAddress)server);
            r.setTimeout(DEFAULT_RESOLVER_TIMEOUT);
            return new ResolverEntry(r);
        }).collect(Collectors.toList()));
    }

    public ExtendedResolver(String[] servers) throws UnknownHostException {
        for (String server : servers) {
            SimpleResolver r = new SimpleResolver(server);
            r.setTimeout(DEFAULT_RESOLVER_TIMEOUT);
            this.resolvers.add(new ResolverEntry(r));
        }
    }

    public ExtendedResolver(Resolver[] resolvers) {
        this(Arrays.asList(resolvers));
    }

    public ExtendedResolver(Iterable<Resolver> resolvers) {
        for (Resolver r : resolvers) {
            this.resolvers.add(new ResolverEntry(r));
        }
    }

    @Override
    public void setPort(int port) {
        for (ResolverEntry re : this.resolvers) {
            re.resolver.setPort(port);
        }
    }

    @Override
    public void setTCP(boolean flag) {
        for (ResolverEntry re : this.resolvers) {
            re.resolver.setTCP(flag);
        }
    }

    @Override
    public void setIgnoreTruncation(boolean flag) {
        for (ResolverEntry re : this.resolvers) {
            re.resolver.setIgnoreTruncation(flag);
        }
    }

    @Override
    public void setEDNS(int version, int payloadSize, int flags, List<EDNSOption> options) {
        for (ResolverEntry re : this.resolvers) {
            re.resolver.setEDNS(version, payloadSize, flags, options);
        }
    }

    @Override
    public void setTSIGKey(TSIG key) {
        for (ResolverEntry re : this.resolvers) {
            re.resolver.setTSIGKey(key);
        }
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query) {
        return this.sendAsync(query, ForkJoinPool.commonPool());
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query, Executor executor) {
        Resolution res = new Resolution(this, query);
        return res.startAsync(executor);
    }

    public Resolver getResolver(int n) {
        if (n < this.resolvers.size()) {
            return this.resolvers.get(n).resolver;
        }
        return null;
    }

    public Resolver[] getResolvers() {
        return (Resolver[])this.resolvers.stream().map(re -> ((ResolverEntry)re).resolver).toArray(Resolver[]::new);
    }

    public void addResolver(Resolver r) {
        this.resolvers.add(new ResolverEntry(r));
    }

    public void deleteResolver(Resolver r) {
        this.resolvers.removeIf(re -> ((ResolverEntry)re).resolver == r);
    }

    public boolean getLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(boolean flag) {
        this.loadBalance = flag;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public String toString() {
        return "ExtendedResolver of " + this.resolvers;
    }

    private static class ResolverEntry {
        private final Resolver resolver;
        private final AtomicInteger failures;

        ResolverEntry(Resolver r) {
            this(r, new AtomicInteger(0));
        }

        public String toString() {
            return this.resolver.toString();
        }

        @Generated
        public ResolverEntry(Resolver resolver2, AtomicInteger failures) {
            this.resolver = resolver2;
            this.failures = failures;
        }
    }

    private static class Resolution {
        private final Message query;
        private final int[] attempts;
        private final int retriesPerResolver;
        private final long endTime;
        private List<ResolverEntry> resolvers;
        private int currentResolver;

        Resolution(ExtendedResolver eres, Message query) {
            this.resolvers = new ArrayList<ResolverEntry>(eres.resolvers);
            this.endTime = System.nanoTime() + eres.timeout.toNanos();
            if (eres.loadBalance) {
                int start = eres.lbStart.updateAndGet(i -> (i + 1) % this.resolvers.size());
                if (start > 0) {
                    ArrayList<ResolverEntry> shuffle = new ArrayList<ResolverEntry>(this.resolvers.size());
                    for (int i2 = 0; i2 < this.resolvers.size(); ++i2) {
                        int pos = (i2 + start) % this.resolvers.size();
                        shuffle.add(this.resolvers.get(pos));
                    }
                    this.resolvers = shuffle;
                }
            } else {
                this.resolvers = this.resolvers.stream().sorted(Comparator.comparingInt(re -> ((ResolverEntry)re).failures.get())).collect(Collectors.toList());
            }
            this.attempts = new int[this.resolvers.size()];
            this.retriesPerResolver = eres.retries;
            this.query = query;
        }

        private CompletionStage<Message> send(Executor executorService) {
            ResolverEntry r = this.resolvers.get(this.currentResolver);
            log.debug("Sending {}/{}, id={} to resolver {} ({}), attempt {} of {}", this.query.getQuestion().getName(), Type.string(this.query.getQuestion().getType()), this.query.getHeader().getID(), this.currentResolver, r.resolver, this.attempts[this.currentResolver] + 1, this.retriesPerResolver);
            int n = this.currentResolver;
            this.attempts[n] = this.attempts[n] + 1;
            return r.resolver.sendAsync(this.query, executorService);
        }

        private CompletionStage<Message> startAsync(Executor executorService) {
            return this.send(executorService).handle((result, ex) -> this.handle((Message)result, (Throwable)ex, executorService)).thenCompose(Function.identity());
        }

        private CompletionStage<Message> handle(Message result, Throwable ex, Executor executorService) {
            AtomicInteger failureCounter = this.resolvers.get(this.currentResolver).failures;
            if (ex != null) {
                log.debug("Failed to resolve {}/{}, id={} with resolver {} ({}) on attempt {} of {}, reason={}", this.query.getQuestion().getName(), Type.string(this.query.getQuestion().getType()), this.query.getHeader().getID(), this.currentResolver, this.resolvers.get(this.currentResolver).resolver, this.attempts[this.currentResolver], this.retriesPerResolver, ex.getMessage());
                failureCounter.incrementAndGet();
                if (this.endTime - System.nanoTime() < 0L) {
                    CompletableFuture<Message> f = new CompletableFuture<Message>();
                    f.completeExceptionally(new IOException("Timed out while trying to resolve " + this.query.getQuestion().getName() + "/" + Type.string(this.query.getQuestion().type) + ", id=" + this.query.getHeader().getID()));
                    return f;
                }
                this.currentResolver = (this.currentResolver + 1) % this.resolvers.size();
                if (this.attempts[this.currentResolver] < this.retriesPerResolver) {
                    return this.send(executorService).handle((r, t) -> this.handle((Message)r, (Throwable)t, executorService)).thenCompose(Function.identity());
                }
                CompletableFuture<Message> f = new CompletableFuture<Message>();
                f.completeExceptionally(ex);
                return f;
            }
            failureCounter.updateAndGet(i -> i > 0 ? (int)Math.log(i) : 0);
            return CompletableFuture.completedFuture(result);
        }
    }
}

