/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.config;

import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.HumanReadable;
import org.ehcache.impl.config.AbstractResourcePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizedResourcePoolImpl<P extends SizedResourcePool>
extends AbstractResourcePool<P, ResourceType<P>>
implements SizedResourcePool,
HumanReadable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SizedResourcePoolImpl.class);
    private final long size;
    private final ResourceUnit unit;

    public SizedResourcePoolImpl(ResourceType<P> type, long size, ResourceUnit unit, boolean persistent) {
        super(type, persistent);
        if (unit == null) {
            throw new NullPointerException("ResourceUnit can not be null");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("Size must be greater than 0");
        }
        if (!type.isPersistable() && persistent) {
            throw new IllegalStateException("Non-persistable resource cannot be configured persistent");
        }
        if (type == ResourceType.Core.HEAP && unit instanceof MemoryUnit) {
            LOGGER.info("Byte based heap resources are deprecated and will be removed in a future version.");
        }
        this.size = size;
        this.unit = unit;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public ResourceUnit getUnit() {
        return this.unit;
    }

    @Override
    public void validateUpdate(ResourcePool newPool) {
        super.validateUpdate(newPool);
        SizedResourcePool sizedPool = (SizedResourcePool)newPool;
        if (!this.getUnit().getClass().equals(sizedPool.getUnit().getClass())) {
            throw new IllegalArgumentException("ResourcePool for " + sizedPool.getType() + " with ResourceUnit '" + sizedPool.getUnit() + "' can not replace '" + this.getUnit() + "'");
        }
        if (sizedPool.getSize() <= 0L) {
            throw new IllegalArgumentException("ResourcePool for " + sizedPool.getType() + " must specify space greater than 0");
        }
    }

    public String toString() {
        return "Pool {" + this.getSize() + " " + this.getUnit() + " " + this.getType() + (this.isPersistent() ? "(persistent)}" : "}");
    }

    @Override
    public String readableString() {
        return this.getSize() + " " + this.getUnit() + " " + (this.isPersistent() ? "(persistent)" : "");
    }
}

