/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.rule;

import java.security.cert.X509Certificate;
import network.oxalis.commons.certvalidator.api.CertificateBucket;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.FailedValidationException;
import network.oxalis.commons.certvalidator.rule.AbstractRule;

public class WhitelistRule
extends AbstractRule {
    private final CertificateBucket certificates;

    public WhitelistRule(CertificateBucket certificates) {
        this.certificates = certificates;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        for (X509Certificate cert : this.certificates) {
            if (!cert.equals(certificate)) continue;
            return;
        }
        throw new FailedValidationException("Certificate is not in whitelist.");
    }
}

