/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.inbound;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import lombok.Generated;
import network.oxalis.ng.api.model.TransmissionIdentifier;
import network.oxalis.ng.api.persist.PersisterHandler;
import network.oxalis.ng.as4.inbound.As4PayloadHeader;
import network.oxalis.ng.as4.lang.AS4Error;
import network.oxalis.ng.as4.lang.OxalisAs4Exception;
import network.oxalis.ng.as4.util.AS4ErrorCode;
import network.oxalis.ng.as4.util.As4MessageFactory;
import network.oxalis.ng.as4.util.MessageId;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class As4FaultInHandler
implements SOAPHandler<SOAPMessageContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(As4FaultInHandler.class);
    private final As4MessageFactory as4MessageFactory;
    private final PersisterHandler persisterHandler;
    private static final String CERTIFICATE_ERROR_MSG = "Cannot find key for certificate";
    private static final String ERROR_CODE_FAILED_CHECK = "FAILED_CHECK";
    private static final String FAULT_CODE_FAILED_CHECK = "FailedCheck";
    private static final String PEPPOL_NOT_SERVICED = "PEPPOL:NOT_SERVICED";

    @Inject
    public As4FaultInHandler(As4MessageFactory as4MessageFactory, PersisterHandler persisterHandler) {
        this.as4MessageFactory = as4MessageFactory;
        this.persisterHandler = persisterHandler;
    }

    @Override
    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    @Override
    public boolean handleMessage(SOAPMessageContext context) {
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext context) {
        OxalisAs4Exception oxalisAs4Exception;
        String messageId = Optional.ofNullable((MessageId)context.get("oxalis.as4.messageId")).map(MessageId::getValue).orElse(null);
        Exception exception = (Exception)context.get(Exception.class.getName());
        if (exception == null) {
            return true;
        }
        log.info("handleFault for Exception", exception);
        AS4Error as4Error = As4FaultInHandler.toAS4Error(exception);
        this.handleAS4Error(context, messageId, as4Error);
        if (as4Error instanceof OxalisAs4Exception && PEPPOL_NOT_SERVICED.equals((oxalisAs4Exception = (OxalisAs4Exception)as4Error).getMessage())) {
            context.put("jakarta.xml.ws.http.response.code", 200);
            context.setScope("jakarta.xml.ws.http.response.code", MessageContext.Scope.APPLICATION);
        }
        return true;
    }

    protected void handleAS4Error(SOAPMessageContext context, String messageId, AS4Error as4Error) {
        SOAPMessage errorMessage = this.as4MessageFactory.createErrorMessage(messageId, as4Error);
        context.setMessage(errorMessage);
        Path firstPayloadPath = (Path)context.get("network.oxalis.as4.first.payload.path");
        As4PayloadHeader firstPayloadHeader = (As4PayloadHeader)context.get("network.oxalis.as4.first.payload.header");
        if (messageId != null && firstPayloadPath != null) {
            try {
                this.persisterHandler.persist(TransmissionIdentifier.of(messageId), firstPayloadHeader, firstPayloadPath, as4Error.getException());
            }
            catch (Exception e) {
                log.error("Unable to persist exception", e);
            }
        }
    }

    @Override
    public void close(MessageContext context) {
    }

    public static AS4Error toAS4Error(Throwable t) {
        Optional<Message> faultMessage = Optional.ofNullable(PhaseInterceptorChain.getCurrentMessage());
        Optional<Message> inMessage = faultMessage.map(Message::getExchange).map(Exchange::getInMessage);
        if (t instanceof Fault) {
            Fault fault = (Fault)t;
            t = fault.getCause();
        }
        if (t instanceof WebServiceException) {
            WebServiceException webServiceException = (WebServiceException)t;
            t = webServiceException.getCause();
        }
        if (t instanceof WSSecurityException && inMessage.isPresent()) {
            boolean IsSecurityException = false;
            String detailSecurityExceptionMessage = "";
            if (null != t.getMessage()) {
                detailSecurityExceptionMessage = t.getMessage();
            }
            if (null != ((WSSecurityException)t).getErrorCode()) {
                String errorCode = ((WSSecurityException)t).getErrorCode().name();
                IsSecurityException = errorCode.equalsIgnoreCase(ERROR_CODE_FAILED_CHECK);
            }
            if (null != ((WSSecurityException)t).getFaultCode()) {
                String faultCode = null == ((WSSecurityException)t).getFaultCode().getLocalPart() ? "" : ((WSSecurityException)t).getFaultCode().getLocalPart();
                IsSecurityException = faultCode.equalsIgnoreCase(FAULT_CODE_FAILED_CHECK);
            }
            if (IsSecurityException || detailSecurityExceptionMessage.equalsIgnoreCase(CERTIFICATE_ERROR_MSG)) {
                return new OxalisAs4Exception(PEPPOL_NOT_SERVICED, AS4ErrorCode.EBMS_0004, AS4ErrorCode.Severity.FAILURE);
            }
            boolean isCompressionError = inMessage.get().getOrDefault("oxalis.as4.compressionErrorDetected", false);
            if (isCompressionError) {
                return new OxalisAs4Exception("Content cannot be compressed after signature/encryption", AS4ErrorCode.EBMS_0303);
            }
            return new OxalisAs4Exception(t.getMessage(), t, AS4ErrorCode.EBMS_0009, AS4ErrorCode.Severity.ERROR);
        }
        if (t instanceof AS4Error) {
            return (AS4Error)((Object)t);
        }
        return new OxalisAs4Exception(t.getMessage(), t, AS4ErrorCode.EBMS_0004, AS4ErrorCode.Severity.ERROR);
    }
}

