/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.bc.BcPKCS12PBEOutputEncryptorBuilder;
import org.cryptacular.generator.AbstractP12Generator;
import org.cryptacular.spec.DigestSpec;

public class LegacyP12Generator
extends AbstractP12Generator {
    private final int iterations;
    private final BcPKCS12PBEOutputEncryptorBuilder keyEncryptorBuilder;
    private final BcPKCS12PBEOutputEncryptorBuilder dataEncryptorBuilder;

    public LegacyP12Generator() {
        this(1024);
    }

    public LegacyP12Generator(int iterations) {
        this.iterations = iterations;
        this.keyEncryptorBuilder = new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, CBCBlockCipher.newInstance(new DESedeEngine())).setIterationCount(iterations);
        this.dataEncryptorBuilder = new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, CBCBlockCipher.newInstance(new RC2Engine())).setIterationCount(iterations);
    }

    @Override
    public int getIterations() {
        return this.iterations;
    }

    @Override
    protected ASN1ObjectIdentifier getDigestAlgorithmId() {
        return OIWObjectIdentifiers.idSHA1;
    }

    @Override
    protected DigestSpec getDigestSpec() {
        return new DigestSpec("SHA1");
    }

    @Override
    protected OutputEncryptor keyOutputEncryptor(char[] password) {
        return this.keyEncryptorBuilder.build(password);
    }

    @Override
    protected OutputEncryptor dataOutputEncryptor(char[] password) {
        return this.dataEncryptorBuilder.build(password);
    }
}

