/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.metadata.resolver.filter.data.impl.MetadataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByReferenceMetadataFilter
implements MetadataFilter {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ByReferenceMetadataFilter.class);
    @Nonnull
    @NonnullElements
    private Map<String, MetadataFilter> filterMap = Collections.emptyMap();

    public void setFilterMappings(@Nonnull @NonnullElements Map<Object, MetadataFilter> map) {
        Constraint.isNotNull(map, "Filter mappings cannot be null");
        this.filterMap = new HashMap<String, MetadataFilter>(map.size());
        for (Map.Entry<Object, MetadataFilter> entry : map.entrySet()) {
            if (entry.getKey() instanceof String) {
                String trimmed = StringSupport.trimOrNull((String)entry.getKey());
                if (trimmed == null || entry.getValue() == null) continue;
                this.filterMap.put(trimmed, entry.getValue());
                continue;
            }
            if (!(entry.getKey() instanceof Collection)) continue;
            for (Object k : (Collection)entry.getKey()) {
                String trimmed;
                if (!(k instanceof String) || entry.getValue() == null || (trimmed = StringSupport.trimOrNull((String)k)) == null) continue;
                this.filterMap.put(trimmed, entry.getValue());
            }
        }
    }

    @Override
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        MetadataSource source = context.get(MetadataSource.class);
        if (source == null || source.getSourceId() == null) {
            this.log.debug("No metadata source ID found in MetadataFilterContext");
            return metadata;
        }
        MetadataFilter filter = this.filterMap.get(source.getSourceId());
        if (filter == null) {
            this.log.debug("No filters defined for resolver '{}', by-reference filter inactive", (Object)source.getSourceId());
            return metadata;
        }
        this.log.debug("Applying by-reference filter to metadata resolver '{}'", (Object)source.getSourceId());
        return filter.filter(metadata, context);
    }
}

