/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.filesystem;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.nio.file.Path;
import java.util.Map;
import lombok.Generated;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.commons.filesystem.FileSystemConf;
import network.oxalis.ng.commons.filesystem.OxalisHomeDirectory;
import network.oxalis.ng.commons.guice.OxalisModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemModule
extends OxalisModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSystemModule.class);

    protected void configure() {
        this.bindSettings(FileSystemConf.class);
    }

    @Provides
    @Singleton
    @Named(value="home")
    protected Path getHomeFolder(OxalisHomeDirectory oxalisHomeDirectory) {
        Path path = oxalisHomeDirectory.detect().toPath();
        log.info("Home folder: {}", (Object)path);
        return path;
    }

    @Provides
    @Singleton
    @Named(value="conf")
    protected Path getConfFolder(@Named(value="reference") Config referenceConfig, @Named(value="home") Path homeFolder) {
        Config config = ConfigFactory.systemProperties().withFallback((ConfigMergeable)referenceConfig);
        Path path = homeFolder;
        if (config.hasPath("oxalis.path.conf")) {
            path = homeFolder.resolve(config.getString("oxalis.path.conf"));
        }
        log.info("Configuration folder: {}", (Object)path);
        return path;
    }

    @Provides
    @Singleton
    @Named(value="inbound")
    protected Path getInboundFolder(Settings<FileSystemConf> settings, @Named(value="home") Path homeFolder) {
        Path path = settings.getPath((Object)FileSystemConf.INBOUND, homeFolder);
        log.info("Inbound folder: {}", (Object)path);
        return path;
    }

    @Provides
    @Named(value="environment")
    protected Map<String, String> getSystemEnvironment() {
        return System.getenv();
    }
}

