/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.sniffer.identifier;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.oxalis.ng.sniffer.identifier.SchemeId;
import network.oxalis.ng.sniffer.lang.InvalidPeppolParticipantException;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.icd.api.Icd;

public class ParticipantId
implements Serializable {
    private static final Pattern ISO6523_PATTERN = Pattern.compile("^(\\d{4}):([^\\s]+)$");
    private static final int INTERNATION_ORG_ID_MAX_LENGTH = 135;
    private final String value;

    public ParticipantId(String participantId) {
        this.value = ParticipantId.parse(participantId);
    }

    public ParticipantId(Icd schemeId, String organisationId) {
        if (schemeId == null) {
            throw new IllegalArgumentException("SchemeId must be specified with a a valid ISO6523 code.");
        }
        if (organisationId == null) {
            throw new IllegalArgumentException("The organisation id must be specified.");
        }
        if (organisationId.length() > 135) {
            throw new IllegalArgumentException(String.format("Invalid organisation id. '%s' is longer than %d characters", organisationId, 135));
        }
        this.value = String.format("%s:%s", schemeId.getCode(), organisationId);
    }

    static String parse(String participantId) throws InvalidPeppolParticipantException {
        String organisationId = participantId.trim().replaceAll("\\s", "");
        Icd schemeId = null;
        Matcher matcher = ISO6523_PATTERN.matcher(organisationId);
        if (!matcher.matches()) {
            throw new InvalidPeppolParticipantException(String.format("ICD not found in '%s'.", participantId));
        }
        String icd = matcher.group(1);
        organisationId = matcher.group(2);
        try {
            schemeId = SchemeId.fromISO6523(icd);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (schemeId == null) {
            throw new InvalidPeppolParticipantException("ICD " + icd + " is unknown");
        }
        return String.format("%s:%s", schemeId.getCode(), organisationId);
    }

    public static ParticipantId valueOf(String participantId) {
        return new ParticipantId(ParticipantId.parse(participantId.trim()));
    }

    public static boolean isValidParticipantIdentifierPattern(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = ISO6523_PATTERN.matcher(value);
        return matcher.find();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticipantId that = (ParticipantId)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    public ParticipantIdentifier toVefa() {
        return ParticipantIdentifier.of(this.value, ParticipantIdentifier.DEFAULT_SCHEME);
    }
}

