/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.RequestAbstractType;
import org.opensaml.saml.saml1.core.ResponseAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InResponseToSecurityHandler
extends AbstractMessageHandler {
    private Logger log = LoggerFactory.getLogger(InResponseToSecurityHandler.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String outboundRequestID = StringSupport.trimOrNull(this.resolveOutboundRequestID(messageContext));
        this.log.debug("Resolved outbound request ID: {}", (Object)outboundRequestID);
        String inboundInResponseTo = StringSupport.trimOrNull(this.resolveInboundInResponseTo(messageContext));
        this.log.debug("Resolved inbound inResponseTo: {}", (Object)inboundInResponseTo);
        if (!Objects.equals(outboundRequestID, inboundInResponseTo)) {
            this.log.warn("Inbound inResponseTo '{}' did not match outbound request ID '{}'", (Object)inboundInResponseTo, (Object)outboundRequestID);
            throw new MessageHandlerException("Inbound inResponseTo did not match outbound request ID");
        }
    }

    private String resolveOutboundRequestID(@Nonnull MessageContext messageContext) {
        MessageContext outboundContext;
        if (messageContext.getParent() instanceof InOutOperationContext && (outboundContext = ((InOutOperationContext)messageContext.getParent()).getOutboundMessageContext()) != null && outboundContext.getMessage() instanceof SAMLObject) {
            SAMLObject outboundMessage = (SAMLObject)outboundContext.getMessage();
            if (outboundMessage instanceof org.opensaml.saml.saml2.core.RequestAbstractType) {
                return ((org.opensaml.saml.saml2.core.RequestAbstractType)outboundMessage).getID();
            }
            if (outboundMessage instanceof RequestAbstractType) {
                return ((RequestAbstractType)outboundMessage).getID();
            }
        }
        return null;
    }

    private String resolveInboundInResponseTo(@Nonnull MessageContext messageContext) {
        MessageContext inboundContext;
        if (messageContext.getParent() instanceof InOutOperationContext && (inboundContext = ((InOutOperationContext)messageContext.getParent()).getInboundMessageContext()) != null && inboundContext.getMessage() instanceof SAMLObject) {
            SAMLObject inboundMessage = (SAMLObject)inboundContext.getMessage();
            if (inboundMessage instanceof StatusResponseType) {
                return ((StatusResponseType)inboundMessage).getInResponseTo();
            }
            if (inboundMessage instanceof ResponseAbstractType) {
                return ((ResponseAbstractType)inboundMessage).getInResponseTo();
            }
        }
        return null;
    }
}

