/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.criterion;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.xmlsec.SignatureValidationConfiguration;

public class SignatureValidationConfigurationCriterion
implements Criterion {
    @Nonnull
    @NonnullElements
    private List<SignatureValidationConfiguration> configs;

    public SignatureValidationConfigurationCriterion(@Nonnull @NonnullElements @NotEmpty List<SignatureValidationConfiguration> configurations) {
        this.configs = List.copyOf((Collection)Constraint.isNotNull(configurations, "List of configurations cannot be null"));
        Constraint.isNotEmpty(this.configs, "At least one configuration is required");
    }

    public SignatureValidationConfigurationCriterion(SignatureValidationConfiguration ... configurations) {
        this.configs = List.of(Constraint.isNotNull(configurations, "List of configurations cannot be null"));
        Constraint.isNotEmpty(this.configs, "At least one configuration is required");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    @NotEmpty
    public List<SignatureValidationConfiguration> getConfigurations() {
        return this.configs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SignatureValidationConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SignatureValidationConfigurationCriterion) {
            return this.configs.equals(((SignatureValidationConfigurationCriterion)obj).getConfigurations());
        }
        return false;
    }
}

