/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.persistence.aop;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import network.oxalis.ng.persistence.api.JdbcTxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTxManagerImpl
implements JdbcTxManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcTxManagerImpl.class);
    private static int instances = 0;
    private int id;
    private final ThreadLocal<JdbcTransaction> threadLocalJdbcTransaction = new ThreadLocal();
    private final DataSource dataSource;

    @Inject
    public JdbcTxManagerImpl(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource not supplied in constructor");
        }
        this.id = instances++;
        this.trace("new instance");
        this.dataSource = dataSource;
    }

    @Override
    public boolean isTransaction() {
        try {
            Connection connection = this.getThreadLocalConnection();
            return connection != null && !connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to check if a transaction has been started", e);
        }
    }

    @Override
    public boolean isConnection() {
        Connection connection = this.getThreadLocalConnection();
        return connection != null;
    }

    @Override
    public void newConnection(boolean autoCommit) {
        try {
            if (this.isTransaction()) {
                String message = "Unable to start a new transaction existing connection is not commited";
                this.trace("Unable to start a new transaction existing connection is not commited");
                throw new IllegalStateException("Unable to start a new transaction existing connection is not commited");
            }
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(autoCommit);
            JdbcTransaction jdbcTransaction = new JdbcTransaction(connection);
            this.threadLocalJdbcTransaction.set(jdbcTransaction);
        }
        catch (SQLException e) {
            String message = "Unable to get a connection from the provided datasource";
            this.trace("Unable to get a connection from the provided datasource");
            throw new IllegalStateException("Unable to get a connection from the provided datasource", e);
        }
    }

    @Override
    public void commit() {
        try {
            if (!this.isTransaction()) {
                String message = "Unable to commit transaction connection, no transaction exists";
                this.trace("Unable to commit transaction connection, no transaction exists");
                throw new IllegalStateException("Unable to commit transaction connection, no transaction exists");
            }
            JdbcTransaction jdbcTransaction = this.threadLocalJdbcTransaction.get();
            if (jdbcTransaction.isRollback()) {
                this.trace("Not commiting - Transaction marked for rollback");
                this.rollback();
            } else {
                this.trace("Commiting transaction");
                jdbcTransaction.getConnection().commit();
            }
        }
        catch (SQLException e) {
            String message = "Unable to commit the transaction";
            this.trace("Unable to commit the transaction");
            throw new IllegalStateException("Unable to commit the transaction", e);
        }
    }

    @Override
    public void rollback() {
        try {
            if (!this.isTransaction()) {
                String message = "Unable to rollback transaction, no transaction exists";
                this.trace("Unable to rollback transaction, no transaction exists");
                throw new IllegalStateException("Unable to rollback transaction, no transaction exists");
            }
            this.getThreadLocalConnection().rollback();
        }
        catch (SQLException e) {
            String message = "Unable to rollback the transaction";
            this.trace("Unable to rollback the transaction");
            throw new IllegalStateException("Unable to rollback the transaction", e);
        }
    }

    @Override
    public void cleanUp() {
        try {
            Connection connection = this.getThreadLocalConnection();
            if (connection != null) {
                this.trace("closing connection");
                connection.close();
            }
        }
        catch (SQLException e) {
            String message = "Unable to close the connection";
            this.trace("Unable to close the connection");
            throw new IllegalStateException("Unable to close the connection", e);
        }
        finally {
            this.trace("Removing transaction manager");
            this.threadLocalJdbcTransaction.remove();
        }
    }

    @Override
    public Connection getConnection() {
        Connection connection = this.getThreadLocalConnection();
        if (connection == null) {
            String message = "Unable to get the connection. Did you forget to annotate the method with @Transactional or the repository with @Repository?";
            this.trace("Unable to get the connection. Did you forget to annotate the method with @Transactional or the repository with @Repository?");
            throw new IllegalStateException("Unable to get the connection. Did you forget to annotate the method with @Transactional or the repository with @Repository?");
        }
        try {
            if (connection.isClosed()) {
                throw new IllegalStateException("Connection is closed!");
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to inspect connection: " + e.getMessage(), e);
        }
        return connection;
    }

    @Override
    public void setRollbackOnly() {
        JdbcTransaction jdbcTransaction = this.threadLocalJdbcTransaction.get();
        if (jdbcTransaction == null) {
            String message = "Unable to mark the transaction as rollbackOnly. Did you forget to annotate the method with @Transactional or the repository with @Repository?";
            this.trace("Unable to mark the transaction as rollbackOnly. Did you forget to annotate the method with @Transactional or the repository with @Repository?");
            throw new IllegalStateException("Unable to mark the transaction as rollbackOnly. Did you forget to annotate the method with @Transactional or the repository with @Repository?");
        }
        this.trace("Transaction marked for rollback");
        jdbcTransaction.setRollback(true);
    }

    private Connection getThreadLocalConnection() {
        JdbcTransaction jdbcTransaction = this.threadLocalJdbcTransaction.get();
        return jdbcTransaction == null ? null : jdbcTransaction.getConnection();
    }

    @Override
    public void trace(String message) {
        if (log.isDebugEnabled()) {
            JdbcTransaction jdbcTransaction = this.threadLocalJdbcTransaction.get();
            String transaction = jdbcTransaction == null ? "" : "" + jdbcTransaction.hashCode();
            log.debug(String.format("Trace %s:%s\t>>\t%s", this.id, transaction, message));
        }
    }

    private class JdbcTransaction {
        private final Connection connection;
        private boolean rollback = false;

        private JdbcTransaction(Connection connection) {
            this.connection = connection;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setRollback(boolean rollback) {
            this.rollback = rollback;
        }

        public boolean isRollback() {
            return this.rollback;
        }
    }
}

