/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.ext.testbed.v1;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import jakarta.inject.Named;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import network.oxalis.ng.api.evidence.EvidenceFactory;
import network.oxalis.ng.api.outbound.TransmissionMessage;
import network.oxalis.ng.api.outbound.TransmissionResponse;
import network.oxalis.ng.api.outbound.Transmitter;
import network.oxalis.ng.api.transmission.TransmissionResult;
import network.oxalis.ng.commons.util.OxalisVersion;
import network.oxalis.ng.ext.testbed.v1.TestbedJaxb;
import network.oxalis.ng.ext.testbed.v1.TestbedTransmissionRequest;
import network.oxalis.ng.ext.testbed.v1.jaxb.InformationType;
import network.oxalis.ng.ext.testbed.v1.jaxb.OutboundResponseType;
import network.oxalis.ng.ext.testbed.v1.jaxb.OutboundType;
import network.oxalis.ng.outbound.transmission.TransmissionRequestFactory;
import network.oxalis.vefa.peppol.common.model.AbstractSimpleIdentifier;
import network.oxalis.vefa.peppol.common.model.TransportProfile;

@Singleton
public class TestbedServlet
extends HttpServlet {
    @Inject
    private Provider<TransmissionRequestFactory> transmissionRequestFactory;
    @Inject
    private Provider<Transmitter> transmitter;
    @Inject
    @Named(value="rem")
    private EvidenceFactory evidenceFactory;
    @Inject
    @Named(value="prioritized")
    private List<TransportProfile> transportProfiles;
    @Inject
    private X509Certificate certificate;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            InformationType informationType = new InformationType();
            informationType.setName("Oxalis");
            informationType.setVersion(OxalisVersion.getVersion());
            informationType.setApiVersion("1.0");
            informationType.getTransportProfile().addAll(this.transportProfiles.stream().map(AbstractSimpleIdentifier::getIdentifier).collect(Collectors.toList()));
            informationType.setCertificate(this.certificate.getEncoded());
            resp.addHeader("Content-Type", "application/xml;charset=UTF-8");
            TestbedJaxb.marshaller().marshal(TestbedJaxb.OBJECT_FACTORY.createInformation(informationType), (Writer)resp.getWriter());
        }
        catch (JAXBException | CertificateEncodingException e) {
            throw new ServletException(e.getMessage(), e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            OutboundType outbound = (OutboundType)TestbedJaxb.unmarshaller().unmarshal((Source)new StreamSource((InputStream)req.getInputStream()), OutboundType.class).getValue();
            TransmissionMessage transmissionMessage = ((TransmissionRequestFactory)this.transmissionRequestFactory.get()).newInstance((InputStream)new ByteArrayInputStream(outbound.getPayload()));
            TransmissionResponse transmissionResponse = outbound.getDestination() == null ? ((Transmitter)this.transmitter.get()).transmit(transmissionMessage) : ((Transmitter)this.transmitter.get()).transmit((TransmissionMessage)new TestbedTransmissionRequest(transmissionMessage, outbound.getDestination()));
            InputStream evidenceInputStream = this.evidenceFactory.write((TransmissionResult)transmissionResponse);
            OutboundResponseType response = new OutboundResponseType();
            response.setReceipt(ByteStreams.toByteArray((InputStream)evidenceInputStream));
            resp.addHeader("Content-Type", "application/xml;charset=UTF-8");
            TestbedJaxb.marshaller().marshal(TestbedJaxb.OBJECT_FACTORY.createOutboundResponse(response), (Writer)resp.getWriter());
        }
        catch (JAXBException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            try {
                OutboundResponseType response = new OutboundResponseType();
                response.setError(e.getMessage());
                resp.addHeader("Content-Type", "application/xml;charset=UTF-8");
                TestbedJaxb.marshaller().marshal(TestbedJaxb.OBJECT_FACTORY.createOutboundResponse(response), (Writer)resp.getWriter());
            }
            catch (JAXBException ex) {
                throw new ServletException(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

