/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.outbound.lookup;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.List;
import network.oxalis.ng.api.lang.OxalisTransmissionException;
import network.oxalis.ng.api.lookup.LookupService;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.api.util.Type;
import network.oxalis.ng.outbound.lookup.LookupConf;
import network.oxalis.vefa.peppol.common.lang.EndpointNotFoundException;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.lookup.LookupClient;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

@Singleton
@Type(value={"default"})
class DefaultLookupService
implements LookupService {
    private final LookupClient lookupClient;
    private final int pintWildcardMigrationPhase;
    private final TransportProfile[] transportProfiles;

    @Inject
    public DefaultLookupService(LookupClient lookupClient, Settings<LookupConf> settings, @Named(value="prioritized") List<TransportProfile> transportProfiles) {
        this.lookupClient = lookupClient;
        this.pintWildcardMigrationPhase = settings.getInt((Object)LookupConf.PINT_WILDCARD_MIGRATION_PHASE);
        this.transportProfiles = transportProfiles.toArray(new TransportProfile[transportProfiles.size()]);
    }

    public Endpoint lookup(Header header) throws OxalisTransmissionException {
        try {
            return this.lookupClient.getEndpoint(header, this.pintWildcardMigrationPhase, this.transportProfiles);
        }
        catch (EndpointNotFoundException | LookupException | PeppolSecurityException e) {
            throw new OxalisTransmissionException(e.getMessage(), e);
        }
    }
}

