/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.outbound.transmission;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import network.oxalis.ng.api.lang.OxalisTransmissionException;
import network.oxalis.ng.api.outbound.MessageSender;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageSenderFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSenderFactory.class);
    private final Injector injector;
    private final Map<TransportProfile, Config> configMap;
    private final List<TransportProfile> prioritizedTransportProfiles;

    @Inject
    public MessageSenderFactory(Injector injector, Config config) {
        this.injector = injector;
        this.configMap = config.getObject("transport").keySet().stream().map(key -> config.getConfig(String.format("transport.%s", key))).collect(Collectors.toMap(c -> TransportProfile.of((String)c.getString("profile")), Function.identity()));
        this.prioritizedTransportProfiles = Collections.unmodifiableList(this.configMap.values().stream().filter(o -> !o.hasPath("enabled") || o.getBoolean("enabled")).sorted((o1, o2) -> Integer.compare(o2.getInt("weight"), o1.getInt("weight"))).map(o -> o.getString("profile")).map(TransportProfile::of).collect(Collectors.toList()));
        log.info("Supported list of transport profiles:");
        this.prioritizedTransportProfiles.forEach(tp -> log.info("=> {}", (Object)tp.getIdentifier()));
    }

    public List<TransportProfile> getPrioritizedTransportProfiles() {
        return this.prioritizedTransportProfiles;
    }

    public String getSender(TransportProfile transportProfile) throws OxalisTransmissionException {
        if (!this.configMap.containsKey(transportProfile)) {
            throw new OxalisTransmissionException(String.format("Transport protocol '%s' not supported.", transportProfile.getIdentifier()));
        }
        return this.configMap.get(transportProfile).getString("sender");
    }

    public MessageSender getMessageSender(TransportProfile transportProfile) throws OxalisTransmissionException {
        return (MessageSender)this.injector.getInstance(Key.get(MessageSender.class, (Annotation)Names.named((String)this.getSender(transportProfile))));
    }
}

