/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.persistence.datasource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.commons.filesystem.ClassLoaderUtils;
import network.oxalis.ng.persistence.testng.PersistenceModuleFactory;
import network.oxalis.ng.persistence.util.PersistenceConf;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(moduleFactory=PersistenceModuleFactory.class)
public class DbcpDataSourceProviderTest {
    @Inject
    private Provider<DataSource> dataSourceProvider;
    @Inject
    private Provider<DataSource> dataSourceProvider2;
    @Inject
    private Settings<PersistenceConf> settings;
    @Inject
    @Named(value="home")
    private Path homeFolder;

    @BeforeClass
    public void setUp() {
        Assert.assertNotNull(this.settings);
    }

    @Test
    public void oxalisDataSourceFactoryIsSingleton() throws Exception {
        Assert.assertNotNull(this.dataSourceProvider);
        Assert.assertEquals(this.dataSourceProvider, this.dataSourceProvider2, (String)"Seems the Singleton pattern in DataSourceProviderFactory is not working");
        DataSource dataSource1 = (DataSource)this.dataSourceProvider.get();
        Assert.assertNotNull((Object)dataSource1);
        DataSource dataSource2 = (DataSource)this.dataSourceProvider.get();
        Assert.assertEquals((Object)dataSource1, (Object)dataSource2, (String)(this.dataSourceProvider.getClass().getSimpleName() + " is not returning a singleton instance of DataSource"));
    }

    @Test
    public void testLoadJdbcDriverUsingCustomClassLoader() throws Exception {
        ConnectionFactory driverConnectionFactory = this.createConnectionFactory(false);
        ObjectName poolName = new ObjectName("network.oxalis", "connectionPool", "TestPool");
        PoolableConnectionFactory factory = new PoolableConnectionFactory(driverConnectionFactory, poolName);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool((ObjectPool)pool);
        pool.setMaxTotal(10);
        pool.setMaxWaitMillis(100L);
        Assert.assertEquals((Object)pool.getFactory(), (Object)factory);
        PoolableConnectionFactory pcf = (PoolableConnectionFactory)pool.getFactory();
        pcf.getPool();
        PoolingDataSource poolingDataSource = new PoolingDataSource((ObjectPool)pool);
        Connection connection = poolingDataSource.getConnection();
        Assert.assertNotNull((Object)connection);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select current_date()");
        Assert.assertTrue((boolean)resultSet.next());
    }

    @Test
    public void testFailWithStaleConnection() throws Exception {
        ConnectionFactory driverConnectionFactory = this.createConnectionFactory(false);
        PoolingDataSource poolingDataSource = this.createPoolingDataSource(driverConnectionFactory);
        try {
            this.runTwoSqlStatementsWithTwoConnections(poolingDataSource);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getClass().getName().contains("CommunicationsException"));
        }
    }

    @Test(enabled=false)
    public void testHandleStaleConnections() throws Exception {
        ConnectionFactory driverConnectionFactory = this.createConnectionFactory(true);
        PoolingDataSource poolingDataSource = this.createPoolingDataSource(driverConnectionFactory);
        this.runTwoSqlStatementsWithTwoConnections(poolingDataSource);
    }

    @Test
    public void testBasicDataSource() throws Exception {
        Path jdbcDriverClassPath = this.settings.getPath((Object)PersistenceConf.DRIVER_PATH, this.homeFolder);
        ClassLoader classLoader = ClassLoaderUtils.initiate((Path)jdbcDriverClassPath);
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(this.settings.getString((Object)PersistenceConf.DRIVER_CLASS));
        basicDataSource.setUrl(this.settings.getString((Object)PersistenceConf.JDBC_CONNECTION_URI));
        basicDataSource.setUsername(this.settings.getString((Object)PersistenceConf.JDBC_USERNAME));
        basicDataSource.setPassword(this.settings.getString((Object)PersistenceConf.JDBC_PASSWORD));
        basicDataSource.setDriverClassLoader(classLoader);
        try {
            Connection connection = basicDataSource.getConnection();
            Assert.assertNotNull((Object)connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void runTwoSqlStatementsWithTwoConnections(PoolingDataSource poolingDataSource) throws SQLException, InterruptedException {
        Connection connection = poolingDataSource.getConnection();
        if (connection.getMetaData().getDatabaseProductName().toLowerCase().contains("mysql")) {
            Assert.assertNotNull((Object)connection);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select current_date()");
            statement = connection.createStatement();
            statement.execute("set session wait_timeout=1");
            Assert.assertTrue((boolean)resultSet.next());
            connection.close();
            System.err.print("Sleeping for 2 seconds....");
            Thread.sleep(2000L);
            System.err.println("Running again now");
            connection = poolingDataSource.getConnection();
            statement = connection.createStatement();
            statement.executeQuery("select current_time()");
        }
    }

    private ConnectionFactory createConnectionFactory(boolean profileSql) throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Class<?> aClass;
        Path jdbcDriverClassPath = this.settings.getPath((Object)PersistenceConf.DRIVER_PATH, this.homeFolder);
        ClassLoader classLoader = ClassLoaderUtils.initiate((Path)jdbcDriverClassPath);
        String jdbcDriverClassName = this.settings.getString((Object)PersistenceConf.DRIVER_CLASS);
        URI connectURI = URI.create(this.settings.getString((Object)PersistenceConf.JDBC_CONNECTION_URI));
        String userName = this.settings.getString((Object)PersistenceConf.JDBC_USERNAME);
        String password = this.settings.getString((Object)PersistenceConf.JDBC_PASSWORD);
        try {
            aClass = Class.forName(jdbcDriverClassName, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Unable to locate class '%s' in class path '%s'", jdbcDriverClassName, jdbcDriverClassPath));
        }
        Driver driver = (Driver)aClass.newInstance();
        Assert.assertTrue((boolean)driver.acceptsURL(connectURI.toString()));
        Properties properties = new Properties();
        properties.put("user", userName);
        properties.put("password", password);
        if (profileSql) {
            properties.put("profileSQL", "true");
        }
        return new DriverConnectionFactory(driver, connectURI.toString(), properties);
    }

    private PoolingDataSource createPoolingDataSource(ConnectionFactory driverConnectionFactory) {
        try {
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(driverConnectionFactory, new ObjectName("network.oxalis", "connectionPool", "TestPool"));
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
            poolableConnectionFactory.setPool((ObjectPool)pool);
            poolableConnectionFactory.setValidationQuery("select 1");
            return new PoolingDataSource((ObjectPool)pool);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unable to create poolable conneciton factory: " + e.getMessage(), e);
        }
    }
}

