/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.persistence.aop;

import com.google.inject.Inject;
import network.oxalis.ng.persistence.api.JdbcTxManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TransactionalMethodInterceptor
implements MethodInterceptor {
    @Inject
    private JdbcTxManager jdbcTxManager;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        boolean transaction = this.jdbcTxManager.isTransaction();
        boolean connection = this.jdbcTxManager.isConnection();
        if (transaction) {
            this.jdbcTxManager.trace(String.format("Transaction already exists so not starting a new one when calling method: %s", invocation.getMethod().getName()));
            return invocation.proceed();
        }
        if (connection) {
            throw new IllegalStateException("Unable to start a transaction, there already exists a connection which is not transactional" + invocation.getMethod().getName());
        }
        try {
            this.jdbcTxManager.newConnection(false);
            this.jdbcTxManager.trace("Started new transaction due to annotation on method: " + invocation.getMethod().getName());
            Object returnValue = invocation.proceed();
            this.jdbcTxManager.commit();
            Object object = returnValue;
            return object;
        }
        catch (Throwable thr) {
            this.jdbcTxManager.trace("Rolling back transaction due to exception: " + thr.getMessage());
            this.jdbcTxManager.rollback();
            this.jdbcTxManager.trace("Rolling back transaction ok");
            throw thr;
        }
        finally {
            this.jdbcTxManager.cleanUp();
        }
    }
}

