/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.persistence.platform;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.SQLException;
import java.util.Set;
import network.oxalis.ng.api.lang.OxalisLoadingException;
import network.oxalis.ng.persistence.annotation.Repository;
import network.oxalis.ng.persistence.api.JdbcTxManager;
import network.oxalis.ng.persistence.api.Platform;

@Repository
class PlatformProvider
implements Provider<Platform> {
    private JdbcTxManager jdbcTxManager;
    private Set<Platform> platforms;

    @Inject
    public PlatformProvider(JdbcTxManager jdbcTxManager, Set<Platform> platforms) {
        this.jdbcTxManager = jdbcTxManager;
        this.platforms = platforms;
    }

    public Platform get() {
        try {
            String productName = this.jdbcTxManager.getConnection().getMetaData().getDatabaseProductName();
            for (Platform platform : this.platforms) {
                if (!platform.detect(productName)) continue;
                return platform;
            }
            throw new OxalisLoadingException(String.format("Unable to load platform for '%s'.", productName));
        }
        catch (SQLException e) {
            throw new OxalisLoadingException("Unable to detect database platform.", (Throwable)e);
        }
    }
}

