/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.persistence.aop;

import com.google.inject.Inject;
import network.oxalis.ng.persistence.annotation.Transactional;
import network.oxalis.ng.persistence.api.JdbcTxManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class RepositoryConnectionMethodInterceptor
implements MethodInterceptor {
    @Inject
    private JdbcTxManager jdbcTxManager;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().isAnnotationPresent(Transactional.class)) {
            this.jdbcTxManager.trace(String.format("Ignoring method %s because it is annotated with Transactional", invocation.getMethod().toGenericString()));
            return invocation.proceed();
        }
        if (this.jdbcTxManager.isConnection()) {
            this.jdbcTxManager.trace("Using existing connection for method " + invocation.getMethod().getName());
            return invocation.proceed();
        }
        try {
            this.jdbcTxManager.newConnection(true);
            this.jdbcTxManager.trace("Fetched connection from datasource");
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.jdbcTxManager.cleanUp();
        }
    }
}

