/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.common;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetAddress;
import java.util.UUID;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.api.util.Type;
import network.oxalis.ng.as4.api.MessageIdGenerator;
import network.oxalis.ng.as4.config.As4Conf;

@Singleton
@Type(value={"default"})
public class DefaultMessageIdGenerator
implements MessageIdGenerator {
    private final String hostname;

    public DefaultMessageIdGenerator(String hostname) {
        this.hostname = hostname;
    }

    @Inject
    public DefaultMessageIdGenerator(Settings<As4Conf> settings) {
        this.hostname = this.getHostname(settings);
    }

    private String getHostname(Settings<As4Conf> settings) {
        String name = settings.getString((Object)As4Conf.HOSTNAME).trim();
        return name.isEmpty() ? this.getLocalHostName() : name;
    }

    private String getLocalHostName() {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    @Override
    public String generate() {
        return String.format("%s@%s", UUID.randomUUID().toString(), this.hostname);
    }
}

