/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.REMEvidenceType;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.RemHelper;
import network.oxalis.vefa.peppol.evidence.rem.SignedRemEvidence;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RemEvidenceTransformer {
    private boolean formattedOutput = true;

    public void toUnformattedXml(SignedRemEvidence signedRemEvidence, OutputStream outputStream) throws RemEvidenceException {
        this.format(signedRemEvidence, outputStream, false);
    }

    public void toFormattedXml(SignedRemEvidence signedRemEvidence, OutputStream outputStream) throws RemEvidenceException {
        this.format(signedRemEvidence, outputStream, true);
    }

    protected void format(SignedRemEvidence signedRemEvidence, OutputStream outputStream, boolean formatted) throws RemEvidenceException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RemEvidenceException("Unable to crate a new transformer");
        }
        if (formatted) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        StreamResult result = new StreamResult(outputStream);
        DOMSource source = new DOMSource(signedRemEvidence.getDocument());
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RemEvidenceException("Transformation of SignedRemEvidence to XML failed:" + e.getMessage(), e);
        }
    }

    protected static JAXBElement<REMEvidenceType> toJaxb(Document signedRemDocument) throws RemEvidenceException {
        try {
            Unmarshaller unmarshaller = RemHelper.getUnmarshaller();
            return unmarshaller.unmarshal((Node)signedRemDocument, REMEvidenceType.class);
        }
        catch (JAXBException e) {
            throw new RemEvidenceException("Unable to create unmarshaller");
        }
    }

    public SignedRemEvidence parse(InputStream inputStream) throws RemEvidenceException {
        Document parsedDocument;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            parsedDocument = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            throw new RemEvidenceException("Unable to create DocumentBuilder " + e.getMessage(), e);
        }
        catch (IOException | SAXException e) {
            throw new RemEvidenceException("Unable to parse xml input " + e.getMessage(), e);
        }
        JAXBElement<REMEvidenceType> remEvidenceTypeJAXBElement = RemEvidenceTransformer.toJaxb(parsedDocument);
        return new SignedRemEvidence(remEvidenceTypeJAXBElement, parsedDocument);
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }
}

